/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.resources.custom;

import com.hazelcast.core.IMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.Main;
import org.pepstock.jem.node.configuration.CustomResourceDefinition;
import org.pepstock.jem.node.resources.Resource;
import org.pepstock.jem.node.resources.custom.ResourceDefinition;
import org.pepstock.jem.node.resources.custom.ResourceDefinitionException;
import org.pepstock.jem.node.resources.custom.ResourceDescriptor;
import org.pepstock.jem.node.resources.custom.ResourceMessage;
import org.pepstock.jem.node.resources.custom.XmlConfigurationResourceDefinition;

public class ResourceDefinitionsManager {
    public static final String XML_RESOURCE_TEMPLATE_FILE_PROPERTY = "jem.xml.resource.template.file";
    private Map<String, ResourceDefinition> customResourceDefinitions = new HashMap<String, ResourceDefinition>();

    public void addCustomResourceDefinition(String customResourceType, ResourceDefinition customResourceDefinition) throws ResourceDefinitionException {
        if (null == customResourceType || customResourceType.trim().equalsIgnoreCase("")) {
            LogAppl.getInstance().emit((MessageInterface)ResourceMessage.JEMR012E, "custom resource type");
            throw new ResourceDefinitionException(ResourceMessage.JEMR012E.toMessage().getFormattedMessage("custom resource type"));
        }
        if (null == customResourceDefinition) {
            LogAppl.getInstance().emit((MessageInterface)ResourceMessage.JEMR012E, "custom resource definition class");
            throw new ResourceDefinitionException(ResourceMessage.JEMR012E.toMessage().getFormattedMessage("custom resource definition class"));
        }
        this.customResourceDefinitions.put(customResourceType, customResourceDefinition);
    }

    public void addCustomResourceDefinition(ResourceDefinition customResourceDefinition) throws ResourceDefinitionException {
        if (null == customResourceDefinition) {
            LogAppl.getInstance().emit((MessageInterface)ResourceMessage.JEMR012E, "custom resource definition class");
            throw new ResourceDefinitionException(ResourceMessage.JEMR012E.toMessage().getFormattedMessage("custom resource definition class"));
        }
        if (null == customResourceDefinition.getResourceDescriptor()) {
            LogAppl.getInstance().emit((MessageInterface)ResourceMessage.JEMR012E, "custom resource descriptor");
            throw new ResourceDefinitionException(ResourceMessage.JEMR012E.toMessage().getFormattedMessage("custom resource descriptor"));
        }
        String type = customResourceDefinition.getResourceDescriptor().getType();
        this.addCustomResourceDefinition(type, customResourceDefinition);
    }

    public ResourceDefinition getCustomResourceDefinition(String customResourceType) throws ResourceDefinitionException {
        if (null == customResourceType) {
            LogAppl.getInstance().emit((MessageInterface)ResourceMessage.JEMR013E, "custom resource type");
            throw new ResourceDefinitionException(ResourceMessage.JEMR013E.toMessage().getFormattedMessage("custom resource type"));
        }
        ResourceDefinition def = this.customResourceDefinitions.get(customResourceType);
        if (null == def) {
            LogAppl.getInstance().emit((MessageInterface)ResourceMessage.JEMR014E, customResourceType);
            throw new ResourceDefinitionException(ResourceMessage.JEMR014E.toMessage().getFormattedMessage(customResourceType));
        }
        return def;
    }

    public boolean hasCustomResourceDefinition(String customResourceType) throws ResourceDefinitionException {
        if (null == customResourceType) {
            LogAppl.getInstance().emit((MessageInterface)ResourceMessage.JEMR018E, "custom resource type");
            throw new ResourceDefinitionException(ResourceMessage.JEMR018E.toMessage().getFormattedMessage("custom resource type"));
        }
        return this.customResourceDefinitions.containsKey(customResourceType);
    }

    public void loadCustomResourceDefinition(CustomResourceDefinition resourceDefinitionConfiguration, String xmlResourceTemplateFile) throws ResourceDefinitionException {
        if (null == resourceDefinitionConfiguration) {
            LogAppl.getInstance().emit((MessageInterface)ResourceMessage.JEMR012E, "custom resource definition configuration");
            throw new ResourceDefinitionException(ResourceMessage.JEMR012E.toMessage().getFormattedMessage("custom resource definition configuration"));
        }
        String className = resourceDefinitionConfiguration.getClassName();
        try {
            ResourceDefinition resourceDefinition;
            Object object = Class.forName(className).newInstance();
            if (object instanceof ResourceDefinition) {
                resourceDefinition = (ResourceDefinition)object;
                if (null != xmlResourceTemplateFile && resourceDefinition instanceof XmlConfigurationResourceDefinition) {
                    ((XmlConfigurationResourceDefinition)resourceDefinition).loadResourceTemplateFile(xmlResourceTemplateFile);
                    LogAppl.getInstance().emit((MessageInterface)ResourceMessage.JEMR020I, xmlResourceTemplateFile);
                }
            } else {
                LogAppl.getInstance().emit((MessageInterface)ResourceMessage.JEMR011E, className);
                throw new ResourceDefinitionException(ResourceMessage.JEMR011E.toMessage().getFormattedMessage(className));
            }
            this.addCustomResourceDefinition(resourceDefinition);
            LogAppl.getInstance().emit((MessageInterface)ResourceMessage.JEMR016I, className, resourceDefinition.getResourceDescriptor().getType());
        }
        catch (ClassNotFoundException e) {
            LogAppl.getInstance().emit((MessageInterface)ResourceMessage.JEMR015E, e, className);
            throw new ResourceDefinitionException(ResourceMessage.JEMR015E.toMessage().getFormattedMessage(className));
        }
        catch (InstantiationException e) {
            LogAppl.getInstance().emit((MessageInterface)ResourceMessage.JEMR015E, e, className);
            throw new ResourceDefinitionException(ResourceMessage.JEMR015E.toMessage().getFormattedMessage(className));
        }
        catch (IllegalAccessException e) {
            LogAppl.getInstance().emit((MessageInterface)ResourceMessage.JEMR015E, e, className);
            throw new ResourceDefinitionException(ResourceMessage.JEMR015E.toMessage().getFormattedMessage(className));
        }
    }

    public Collection<ResourceDefinition> getAllCustomResourceDefinitions() {
        return this.customResourceDefinitions.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNotExistingTypesResources() throws ResourceDefinitionException {
        IMap resourceMap = Main.HAZELCAST.getMap("org.pepstock.jem.common.resources");
        for (Resource resource : resourceMap.values()) {
            if (this.isValidResourceType(resource.getType())) continue;
            String name = resource.getName();
            try {
                resourceMap.lock((Object)name);
                resource = (Resource)resourceMap.remove((Object)name);
                LogAppl.getInstance().emit((MessageInterface)ResourceMessage.JEMR019W, name, resource.getType());
            }
            finally {
                resourceMap.unlock((Object)name);
            }
        }
    }

    private boolean isValidResourceType(String resourceType) throws ResourceDefinitionException {
        return resourceType.equalsIgnoreCase("ftp") || resourceType.equalsIgnoreCase("http") || resourceType.equalsIgnoreCase("jdbc") || resourceType.equalsIgnoreCase("jms") || resourceType.equalsIgnoreCase("jppf") || Main.CUSTOM_RESOURCE_DEFINITION_MANAGER.hasCustomResourceDefinition(resourceType);
    }

    public Collection<String> getAllCustomResourceNames() {
        return new ArrayList<String>(this.customResourceDefinitions.keySet());
    }

    public ResourceDescriptor getResourceDescriptorOf(String resourceType) {
        return this.customResourceDefinitions.get(resourceType).getResourceDescriptor();
    }
}

