/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.resources;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.query.Predicate;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import java.security.Key;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.codec.CodecSupport;
import org.apache.shiro.crypto.AesCipherService;
import org.apache.shiro.crypto.hash.Sha256Hash;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.resources.CryptedValueAndHash;
import org.pepstock.jem.node.security.Crypto;
import org.pepstock.jem.node.security.Role;
import org.pepstock.jem.node.security.RolesQueuePredicate;
import org.pepstock.jem.node.security.StringPermission;
import org.pepstock.jem.node.security.User;

public class ResourcesUtil {
    private static ResourcesUtil INSTANCE = null;
    public static final String ACTION_PARM = "action";
    private Key key = null;

    private ResourcesUtil() {
    }

    public static ResourcesUtil getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ResourcesUtil();
        }
        return INSTANCE;
    }

    public void createKey() {
        AesCipherService aesService = new AesCipherService();
        this.setKey(aesService.generateNewKey());
    }

    public Key getKey() {
        return this.key;
    }

    public void setKey(Key key) {
        this.key = key;
    }

    public CryptedValueAndHash encrypt(String value) throws Exception {
        byte[] whatBytes = CodecSupport.toBytes((String)value);
        byte[] cryptBytes = Crypto.crypt(whatBytes, this.key);
        CryptedValueAndHash result = new CryptedValueAndHash();
        result.setCryptedValue(Base64.encode(cryptBytes, 2 * cryptBytes.length));
        Sha256Hash hasher = new Sha256Hash((Object)result.getCryptedValue());
        String valueHashed = hasher.toBase64();
        result.setHash(valueHashed);
        return result;
    }

    public String decrypt(CryptedValueAndHash object) throws Exception {
        return this.decrypt(object.getCryptedValue(), object.getHash());
    }

    public String decrypt(String cryptedValue, String hash) throws Exception {
        Sha256Hash hasher = new Sha256Hash((Object)cryptedValue);
        String valueHashed = hasher.toBase64();
        if (!valueHashed.equalsIgnoreCase(hash)) {
            throw new Exception(NodeMessage.JEMC118E.toMessage().getMessage());
        }
        byte[] decryptBytes = Crypto.decrypt(Base64.decode(cryptedValue), this.key);
        String result = CodecSupport.toString((byte[])decryptBytes);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkPermissions(String userid, String permission, HazelcastInstance instance) throws AuthorizationException {
        User user = new User(userid);
        RolesQueuePredicate predicate = new RolesQueuePredicate();
        predicate.setUser(user);
        IMap roles = instance.getMap("org.pepstock.jem.roles");
        ArrayList myroles = null;
        if (roles.lockMap(10L, TimeUnit.SECONDS)) {
            try {
                myroles = new ArrayList(roles.values((Predicate)predicate));
            }
            finally {
                roles.unlockMap();
            }
        } else {
            throw new AuthorizationException(NodeMessage.JEMC119E.toMessage().getFormattedMessage("org.pepstock.jem.roles"));
        }
        StringPermission sPermission = new StringPermission(permission);
        for (Role role : myroles) {
            for (String perm : role.getPermissions()) {
                StringPermission sPerm = new StringPermission(perm);
                if (!sPerm.implies(sPermission)) continue;
                return;
            }
        }
        throw new AuthorizationException(NodeMessage.JEMC120E.toMessage().getFormattedMessage(userid, permission));
    }
}

