/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.resources;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.pepstock.jem.node.resources.ResourceProperty;

public class ResourcePropertyConverter
implements Converter {
    public boolean canConvert(Class clazz) {
        return clazz.equals(ResourceProperty.class);
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext arg2) {
        ResourceProperty p = (ResourceProperty)value;
        writer.addAttribute("name", p.getName());
        writer.addAttribute("visible", String.valueOf(p.isVisible()));
        writer.addAttribute("override", String.valueOf(p.isOverride()));
        if (p.getHash() != null) {
            writer.addAttribute("hash", p.getHash());
        }
        writer.setValue(p.getValue());
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext arg1) {
        String name = reader.getAttribute("name");
        String visible = reader.getAttribute("visible");
        String override = reader.getAttribute("override");
        String hash = reader.getAttribute("hash");
        String value = reader.getValue();
        ResourceProperty property = new ResourceProperty();
        property.setName(name);
        property.setOverride(Boolean.valueOf(override));
        property.setVisible(Boolean.valueOf(visible));
        if (hash != null) {
            property.setHash(hash);
        }
        property.setValue(value);
        return property;
    }
}

