/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.persistence;

import com.hazelcast.core.MapStore;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.persistence.SQLContainer;
import org.pepstock.jem.node.persistence.UserPreferencesDBManager;
import org.pepstock.jem.node.security.UserPreference;

public class UserPreferencesMapManager
implements MapStore<String, HashMap<String, UserPreference>> {
    private UserPreferencesDBManager dbManager = UserPreferencesDBManager.getInstance();
    private SQLContainer sql = this.dbManager.getPreferencesSqlContainer();

    public HashMap<String, UserPreference> load(String userId) {
        if (this.dbManager == null) {
            LogAppl.getInstance().emit(NodeMessage.JEMC044E);
            throw new RuntimeException(NodeMessage.JEMC044E.toMessage().getMessage());
        }
        HashMap<String, UserPreference> userPreferences = null;
        try {
            userPreferences = this.dbManager.getUserPreferences(this.sql.getGetStatement(), userId);
        }
        catch (SQLException e) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC043E, e);
            throw new RuntimeException(e);
        }
        return userPreferences;
    }

    public Set<String> loadAllKeys() {
        if (this.dbManager == null) {
            LogAppl.getInstance().emit(NodeMessage.JEMC044E);
            throw new RuntimeException(NodeMessage.JEMC044E.toMessage().getMessage());
        }
        Set<String> set = null;
        try {
            set = this.dbManager.getAllUserIds(this.sql.getGetAllKeysStatement());
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC045I, String.valueOf(set.size()), "org.pepstock.jem.user.preferences");
        }
        catch (SQLException e) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC043E, e);
            throw new RuntimeException(e);
        }
        return set;
    }

    public void delete(String userId) {
        if (this.dbManager == null) {
            LogAppl.getInstance().emit(NodeMessage.JEMC044E);
            throw new RuntimeException(NodeMessage.JEMC044E.toMessage().getMessage());
        }
        try {
            this.dbManager.delete(this.sql.getDeleteStatement(), userId);
        }
        catch (SQLException e) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC043E, e);
            throw new RuntimeException(e);
        }
    }

    public void store(String userId, HashMap<String, UserPreference> userPreferences) {
        if (this.dbManager == null) {
            LogAppl.getInstance().emit(NodeMessage.JEMC044E);
            throw new RuntimeException(NodeMessage.JEMC044E.toMessage().getMessage());
        }
        try {
            this.dbManager.insert(this.sql.getInsertStatement(), userId, userPreferences);
        }
        catch (SQLException e) {
            try {
                this.dbManager.update(this.sql.getUpdateStatement(), userId, userPreferences);
            }
            catch (SQLException e1) {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC043E, e1);
                throw new RuntimeException(e1);
            }
        }
    }

    public void storeAll(Map<String, HashMap<String, UserPreference>> userPreferencess) {
        if (this.dbManager == null) {
            LogAppl.getInstance().emit(NodeMessage.JEMC044E);
            throw new RuntimeException(NodeMessage.JEMC044E.toMessage().getMessage());
        }
        for (Map.Entry<String, HashMap<String, UserPreference>> userPreferences : userPreferencess.entrySet()) {
            try {
                this.dbManager.insert(this.sql.getInsertStatement(), userPreferences.getKey(), userPreferences.getValue());
            }
            catch (SQLException e) {
                try {
                    this.dbManager.update(this.sql.getUpdateStatement(), userPreferences.getKey(), userPreferences.getValue());
                }
                catch (SQLException e1) {
                    LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC043E, e1);
                    throw new RuntimeException(e1);
                }
            }
        }
    }

    public void deleteAll(Collection<String> ids) {
        if (this.dbManager == null) {
            LogAppl.getInstance().emit(NodeMessage.JEMC044E);
            throw new RuntimeException(NodeMessage.JEMC044E.toMessage().getMessage());
        }
        for (String id : ids) {
            try {
                this.dbManager.delete(this.sql.getDeleteStatement(), id);
            }
            catch (SQLException e) {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC043E, e);
                throw new RuntimeException(e);
            }
        }
    }

    public Map<String, HashMap<String, UserPreference>> loadAll(Collection<String> userIds) {
        if (this.dbManager == null) {
            LogAppl.getInstance().emit(NodeMessage.JEMC044E);
            throw new RuntimeException(NodeMessage.JEMC044E.toMessage().getMessage());
        }
        StringBuilder sb = new StringBuilder();
        Iterator<String> iter = userIds.iterator();
        while (true) {
            String userPreferencesName = iter.next();
            sb.append("'").append(userPreferencesName).append("'");
            if (!iter.hasNext()) break;
            sb.append(", ");
        }
        String sqlString = MessageFormat.format(this.sql.getGetAllStatement(), sb.toString());
        HashMap<String, HashMap<String, UserPreference>> userPreferencess = null;
        try {
            userPreferencess = this.dbManager.getAllUserPreferences(sqlString);
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC055I, String.valueOf(userPreferencess.size()), "org.pepstock.jem.user.preferences");
        }
        catch (SQLException e) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC043E, e);
            throw new RuntimeException(e);
        }
        return userPreferencess;
    }
}

