/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.persistence;

import com.thoughtworks.xstream.XStream;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.pepstock.jem.node.persistence.DBPoolManager;
import org.pepstock.jem.node.persistence.SQLContainer;
import org.pepstock.jem.node.security.UserPreference;

public class UserPreferencesDBManager {
    private static final UserPreferencesDBManager INSTANCE = new UserPreferencesDBManager();
    private XStream xs = new XStream();
    private SQLContainer preferencesSqlContainer = null;

    private UserPreferencesDBManager() {
    }

    public SQLContainer getPreferencesSqlContainer() {
        return this.preferencesSqlContainer;
    }

    public void setPreferencesSqlContainer(SQLContainer preferencesSqlContainer) {
        this.preferencesSqlContainer = preferencesSqlContainer;
    }

    public static synchronized UserPreferencesDBManager getInstance() {
        return INSTANCE;
    }

    public static boolean isInstanciated() {
        return INSTANCE != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String delete, String userId) throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            PreparedStatement updateStmt = connection.prepareStatement(delete);
            updateStmt.setString(1, userId);
            updateStmt.executeUpdate();
            updateStmt.close();
            connection.commit();
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(String insert, String userId, HashMap<String, UserPreference> userPreferences) throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            StringReader reader = new StringReader(this.xs.toXML(userPreferences));
            PreparedStatement updateStmt = connection.prepareStatement(insert);
            updateStmt.setString(1, userId);
            updateStmt.setCharacterStream(2, reader);
            updateStmt.executeUpdate();
            updateStmt.close();
            connection.commit();
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String update, String userId, HashMap<String, UserPreference> userPreferences) throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            StringReader reader = new StringReader(this.xs.toXML(userPreferences));
            PreparedStatement updateStmt = connection.prepareStatement(update);
            updateStmt.setCharacterStream(1, reader);
            updateStmt.setString(2, userId);
            updateStmt.executeUpdate();
            updateStmt.close();
            connection.commit();
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAllUserIds(String query) throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            HashSet<String> allIds = new HashSet<String>();
            while (rs.next()) {
                allIds.add(rs.getObject(1).toString());
            }
            rs.close();
            stmt.close();
            HashSet<String> hashSet = allIds;
            return hashSet;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, HashMap<String, UserPreference>> getAllUserPreferences(String query) throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            HashMap<String, HashMap<String, UserPreference>> allUserPreferences = new HashMap<String, HashMap<String, UserPreference>>();
            while (rs.next()) {
                HashMap userPreferences = (HashMap)this.xs.fromXML(rs.getCharacterStream(1));
                allUserPreferences.put(rs.getObject(2).toString(), userPreferences);
            }
            rs.close();
            stmt.close();
            HashMap<String, HashMap<String, UserPreference>> hashMap = allUserPreferences;
            return hashMap;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, UserPreference> getUserPreferences(String query, String userId) throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            PreparedStatement stmt = connection.prepareStatement(query);
            stmt.setString(1, userId);
            ResultSet rs = stmt.executeQuery();
            HashMap userPreferences = null;
            if (rs.next()) {
                userPreferences = (HashMap)this.xs.fromXML(rs.getCharacterStream(1));
            }
            rs.close();
            stmt.close();
            HashMap hashMap = userPreferences;
            return hashMap;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUserPreferencesSize() throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery(this.preferencesSqlContainer.getCheckQueueSizeStatement());
            rs.next();
            long size = rs.getLong(1);
            rs.close();
            stmt.close();
            long l = size;
            return l;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }
}

