/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.persistence;

import com.hazelcast.core.MapStore;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.configuration.SwarmConfiguration;
import org.pepstock.jem.node.persistence.RoutingConfigDBManager;
import org.pepstock.jem.node.persistence.SQLContainer;

public class RoutingConfigMapManager
implements MapStore<String, SwarmConfiguration> {
    private RoutingConfigDBManager dbManager = RoutingConfigDBManager.getInstance();
    private SQLContainer sql = this.dbManager.getRoutingSqlContainer();

    public SwarmConfiguration load(String routingConfName) {
        if (this.dbManager == null) {
            LogAppl.getInstance().emit(NodeMessage.JEMC044E);
            throw new RuntimeException(NodeMessage.JEMC044E.toMessage().getMessage());
        }
        SwarmConfiguration routingConf = null;
        try {
            routingConf = this.dbManager.getSwarmConfiguration(this.sql.getGetStatement(), routingConfName);
        }
        catch (SQLException e) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC043E, e);
            throw new RuntimeException(e);
        }
        return routingConf;
    }

    public Set<String> loadAllKeys() {
        if (this.dbManager == null) {
            LogAppl.getInstance().emit(NodeMessage.JEMC044E);
            throw new RuntimeException(NodeMessage.JEMC044E.toMessage().getMessage());
        }
        Set<String> set = null;
        try {
            set = this.dbManager.getAllSwarmConfigurationNames(this.sql.getGetAllKeysStatement());
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC045I, String.valueOf(set.size()), "org.pepstock.jem.routingConfig");
        }
        catch (SQLException e) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC043E, e);
            throw new RuntimeException(e);
        }
        return set;
    }

    public void delete(String routingConfName) {
        if (this.dbManager == null) {
            LogAppl.getInstance().emit(NodeMessage.JEMC044E);
            throw new RuntimeException(NodeMessage.JEMC044E.toMessage().getMessage());
        }
        try {
            this.dbManager.delete(this.sql.getDeleteStatement(), routingConfName);
        }
        catch (SQLException e) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC043E, e);
            throw new RuntimeException(e);
        }
    }

    public void store(String routingConfName, SwarmConfiguration routingConf) {
        if (this.dbManager == null) {
            LogAppl.getInstance().emit(NodeMessage.JEMC044E);
            throw new RuntimeException(NodeMessage.JEMC044E.toMessage().getMessage());
        }
        try {
            this.dbManager.insert(this.sql.getInsertStatement(), routingConf);
        }
        catch (SQLException e) {
            try {
                this.dbManager.update(this.sql.getUpdateStatement(), routingConf);
            }
            catch (SQLException e1) {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC043E, e1);
                throw new RuntimeException(e1);
            }
        }
    }

    public void storeAll(Map<String, SwarmConfiguration> routingConfs) {
        if (this.dbManager == null) {
            LogAppl.getInstance().emit(NodeMessage.JEMC044E);
            throw new RuntimeException(NodeMessage.JEMC044E.toMessage().getMessage());
        }
        for (SwarmConfiguration routingConf : routingConfs.values()) {
            try {
                this.dbManager.insert(this.sql.getInsertStatement(), routingConf);
            }
            catch (SQLException e) {
                try {
                    this.dbManager.update(this.sql.getUpdateStatement(), routingConf);
                }
                catch (SQLException e1) {
                    LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC043E, e1);
                    throw new RuntimeException(e1);
                }
            }
        }
    }

    public void deleteAll(Collection<String> ids) {
        if (this.dbManager == null) {
            LogAppl.getInstance().emit(NodeMessage.JEMC044E);
            throw new RuntimeException(NodeMessage.JEMC044E.toMessage().getMessage());
        }
        for (String id : ids) {
            try {
                this.dbManager.delete(this.sql.getDeleteStatement(), id);
            }
            catch (SQLException e) {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC043E, e);
                throw new RuntimeException(e);
            }
        }
    }

    public Map<String, SwarmConfiguration> loadAll(Collection<String> routingConfNames) {
        if (this.dbManager == null) {
            LogAppl.getInstance().emit(NodeMessage.JEMC044E);
            throw new RuntimeException(NodeMessage.JEMC044E.toMessage().getMessage());
        }
        StringBuilder sb = new StringBuilder();
        Iterator<String> iter = routingConfNames.iterator();
        while (true) {
            String routingConfName = iter.next();
            sb.append("'").append(routingConfName).append("'");
            if (!iter.hasNext()) break;
            sb.append(", ");
        }
        String sqlString = MessageFormat.format(this.sql.getGetAllStatement(), sb.toString());
        HashMap<String, SwarmConfiguration> routingConfs = null;
        try {
            routingConfs = this.dbManager.getAllSwarmConfigurations(sqlString);
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC055I, String.valueOf(routingConfs.size()), "org.pepstock.jem.routingConfig");
        }
        catch (SQLException e) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC043E, e);
            throw new RuntimeException(e);
        }
        return routingConfs;
    }
}

