/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.persistence;

import com.thoughtworks.xstream.XStream;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.pepstock.jem.node.configuration.SwarmConfiguration;
import org.pepstock.jem.node.persistence.DBPoolManager;
import org.pepstock.jem.node.persistence.SQLContainer;

public class RoutingConfigDBManager {
    private static final RoutingConfigDBManager INSTANCE = new RoutingConfigDBManager();
    private XStream xs = new XStream();
    private SQLContainer routingSqlContainer = null;

    private RoutingConfigDBManager() {
    }

    public SQLContainer getRoutingSqlContainer() {
        return this.routingSqlContainer;
    }

    public void setRoutingSqlContainer(SQLContainer routingSqlContainer) {
        this.routingSqlContainer = routingSqlContainer;
    }

    public static synchronized RoutingConfigDBManager getInstance() {
        return INSTANCE;
    }

    public static boolean isInstanciated() {
        return INSTANCE != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String delete, String routingConfName) throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            PreparedStatement updateStmt = connection.prepareStatement(delete);
            updateStmt.setString(1, routingConfName);
            updateStmt.executeUpdate();
            updateStmt.close();
            connection.commit();
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(String insert, SwarmConfiguration routingConf) throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            StringReader reader = new StringReader(this.xs.toXML((Object)routingConf));
            PreparedStatement updateStmt = connection.prepareStatement(insert);
            updateStmt.setString(1, routingConf.getName());
            updateStmt.setCharacterStream(2, reader);
            updateStmt.executeUpdate();
            updateStmt.close();
            connection.commit();
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String update, SwarmConfiguration routingConf) throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            StringReader reader = new StringReader(this.xs.toXML((Object)routingConf));
            PreparedStatement updateStmt = connection.prepareStatement(update);
            updateStmt.setCharacterStream(1, reader);
            updateStmt.setString(2, routingConf.getName());
            updateStmt.executeUpdate();
            updateStmt.close();
            connection.commit();
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAllSwarmConfigurationNames(String query) throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            HashSet<String> allIds = new HashSet<String>();
            while (rs.next()) {
                allIds.add(rs.getObject(1).toString());
            }
            rs.close();
            stmt.close();
            HashSet<String> hashSet = allIds;
            return hashSet;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, SwarmConfiguration> getAllSwarmConfigurations(String query) throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            HashMap<String, SwarmConfiguration> allSwarmConfigurations = new HashMap<String, SwarmConfiguration>();
            while (rs.next()) {
                SwarmConfiguration routingConf = (SwarmConfiguration)this.xs.fromXML(rs.getCharacterStream(1));
                allSwarmConfigurations.put(routingConf.getName(), routingConf);
            }
            rs.close();
            stmt.close();
            HashMap<String, SwarmConfiguration> hashMap = allSwarmConfigurations;
            return hashMap;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SwarmConfiguration getSwarmConfiguration(String query, String routingConfName) throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            PreparedStatement stmt = connection.prepareStatement(query);
            stmt.setString(1, routingConfName);
            ResultSet rs = stmt.executeQuery();
            SwarmConfiguration routingConf = null;
            if (rs.next()) {
                routingConf = (SwarmConfiguration)this.xs.fromXML(rs.getCharacterStream(1));
            }
            rs.close();
            stmt.close();
            SwarmConfiguration swarmConfiguration = routingConf;
            return swarmConfiguration;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRoutingConfigSize() throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery(this.routingSqlContainer.getCheckQueueSizeStatement());
            rs.next();
            long size = rs.getLong(1);
            rs.close();
            stmt.close();
            long l = size;
            return l;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }
}

