/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.persistence;

import com.hazelcast.core.MapStore;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.persistence.RolesDBManager;
import org.pepstock.jem.node.persistence.SQLContainer;
import org.pepstock.jem.node.security.Role;

public class RolesMapManager
implements MapStore<String, Role> {
    private RolesDBManager dbManager = RolesDBManager.getInstance();
    private SQLContainer sql = this.dbManager.getRolesSqlContainer();

    public Role load(String roleName) {
        if (this.dbManager == null) {
            LogAppl.getInstance().emit(NodeMessage.JEMC044E);
            throw new RuntimeException(NodeMessage.JEMC044E.toMessage().getMessage());
        }
        Role role = null;
        try {
            role = this.dbManager.getRole(this.sql.getGetStatement(), roleName);
        }
        catch (SQLException e) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC043E, e);
            throw new RuntimeException(e);
        }
        return role;
    }

    public Set<String> loadAllKeys() {
        if (this.dbManager == null) {
            LogAppl.getInstance().emit(NodeMessage.JEMC044E);
            throw new RuntimeException(NodeMessage.JEMC044E.toMessage().getMessage());
        }
        Set<String> set = null;
        try {
            set = this.dbManager.getAllRolesNames(this.sql.getGetAllKeysStatement());
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC045I, String.valueOf(set.size()), "org.pepstock.jem.roles");
        }
        catch (SQLException e) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC043E, e);
            throw new RuntimeException(e);
        }
        return set;
    }

    public void delete(String roleName) {
        if (this.dbManager == null) {
            LogAppl.getInstance().emit(NodeMessage.JEMC044E);
            throw new RuntimeException(NodeMessage.JEMC044E.toMessage().getMessage());
        }
        try {
            this.dbManager.delete(this.sql.getDeleteStatement(), roleName);
        }
        catch (SQLException e) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC043E, e);
            throw new RuntimeException(e);
        }
    }

    public void store(String roleName, Role role) {
        if (this.dbManager == null) {
            LogAppl.getInstance().emit(NodeMessage.JEMC044E);
            throw new RuntimeException(NodeMessage.JEMC044E.toMessage().getMessage());
        }
        try {
            this.dbManager.insert(this.sql.getInsertStatement(), role);
        }
        catch (SQLException e) {
            try {
                this.dbManager.update(this.sql.getUpdateStatement(), role);
            }
            catch (SQLException e1) {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC043E, e1);
                throw new RuntimeException(e1);
            }
        }
    }

    public void storeAll(Map<String, Role> roles) {
        if (this.dbManager == null) {
            LogAppl.getInstance().emit(NodeMessage.JEMC044E);
            throw new RuntimeException(NodeMessage.JEMC044E.toMessage().getMessage());
        }
        for (Role role : roles.values()) {
            try {
                this.dbManager.insert(this.sql.getInsertStatement(), role);
            }
            catch (SQLException e) {
                try {
                    this.dbManager.update(this.sql.getUpdateStatement(), role);
                }
                catch (SQLException e1) {
                    LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC043E, e1);
                    throw new RuntimeException(e1);
                }
            }
        }
    }

    public void deleteAll(Collection<String> ids) {
        if (this.dbManager == null) {
            LogAppl.getInstance().emit(NodeMessage.JEMC044E);
            throw new RuntimeException(NodeMessage.JEMC044E.toMessage().getMessage());
        }
        for (String id : ids) {
            try {
                this.dbManager.delete(this.sql.getDeleteStatement(), id);
            }
            catch (SQLException e) {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC043E, e);
                throw new RuntimeException(e);
            }
        }
    }

    public Map<String, Role> loadAll(Collection<String> roleNames) {
        if (this.dbManager == null) {
            LogAppl.getInstance().emit(NodeMessage.JEMC044E);
            throw new RuntimeException(NodeMessage.JEMC044E.toMessage().getMessage());
        }
        StringBuilder sb = new StringBuilder();
        Iterator<String> iter = roleNames.iterator();
        while (true) {
            String roleName = iter.next();
            sb.append("'").append(roleName).append("'");
            if (!iter.hasNext()) break;
            sb.append(", ");
        }
        String sqlString = MessageFormat.format(this.sql.getGetAllStatement(), sb.toString());
        HashMap<String, Role> roles = null;
        try {
            roles = this.dbManager.getAllRoles(sqlString);
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC055I, String.valueOf(roles.size()), "org.pepstock.jem.roles");
        }
        catch (SQLException e) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC043E, e);
            throw new RuntimeException(e);
        }
        return roles;
    }
}

