/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.persistence;

import com.thoughtworks.xstream.XStream;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.pepstock.jem.node.persistence.DBPoolManager;
import org.pepstock.jem.node.persistence.SQLContainer;
import org.pepstock.jem.node.security.Role;

public class RolesDBManager {
    private static final RolesDBManager INSTANCE = new RolesDBManager();
    private XStream xs = new XStream();
    private SQLContainer rolesSqlContainer = null;

    private RolesDBManager() {
    }

    public SQLContainer getRolesSqlContainer() {
        return this.rolesSqlContainer;
    }

    public void setRolesSqlContainer(SQLContainer rolesSqlContainer) {
        this.rolesSqlContainer = rolesSqlContainer;
    }

    public static synchronized RolesDBManager getInstance() {
        return INSTANCE;
    }

    public static boolean isInstanciated() {
        return INSTANCE != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String delete, String roleName) throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            PreparedStatement updateStmt = connection.prepareStatement(delete);
            updateStmt.setString(1, roleName);
            updateStmt.executeUpdate();
            updateStmt.close();
            connection.commit();
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(String insert, Role role) throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            StringReader reader = new StringReader(this.xs.toXML((Object)role));
            PreparedStatement updateStmt = connection.prepareStatement(insert);
            updateStmt.setString(1, role.getName());
            updateStmt.setCharacterStream(2, reader);
            updateStmt.executeUpdate();
            updateStmt.close();
            connection.commit();
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String update, Role role) throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            StringReader reader = new StringReader(this.xs.toXML((Object)role));
            PreparedStatement updateStmt = connection.prepareStatement(update);
            updateStmt.setCharacterStream(1, reader);
            updateStmt.setString(2, role.getName());
            updateStmt.executeUpdate();
            updateStmt.close();
            connection.commit();
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAllRolesNames(String query) throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            HashSet<String> allIds = new HashSet<String>();
            while (rs.next()) {
                allIds.add(rs.getObject(1).toString());
            }
            rs.close();
            stmt.close();
            HashSet<String> hashSet = allIds;
            return hashSet;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Role> getAllRoles(String query) throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            HashMap<String, Role> allRoles = new HashMap<String, Role>();
            while (rs.next()) {
                Role role = (Role)this.xs.fromXML(rs.getCharacterStream(1));
                allRoles.put(role.getName(), role);
            }
            rs.close();
            stmt.close();
            HashMap<String, Role> hashMap = allRoles;
            return hashMap;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Role getRole(String query, String roleName) throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            PreparedStatement stmt = connection.prepareStatement(query);
            stmt.setString(1, roleName);
            ResultSet rs = stmt.executeQuery();
            Role role = null;
            if (rs.next()) {
                role = (Role)this.xs.fromXML(rs.getCharacterStream(1));
            }
            rs.close();
            stmt.close();
            Role role2 = role;
            return role2;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRolesSize() throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery(this.rolesSqlContainer.getCheckQueueSizeStatement());
            rs.next();
            long size = rs.getLong(1);
            rs.close();
            stmt.close();
            long l = size;
            return l;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }
}

