/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.persistence;

import com.hazelcast.core.IMap;
import java.util.concurrent.TimeUnit;
import org.pepstock.jem.Job;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.Main;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.persistence.RedoStatement;

public class RedoManager {
    private String queueName = null;

    public RedoManager(String queueName) {
        this.queueName = queueName;
    }

    public String getQueueName() {
        return this.queueName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(Job job) {
        IMap redoMap = Main.HAZELCAST.getMap("org.pepstock.jem.redo");
        try {
            redoMap.lockMap(10L, TimeUnit.SECONDS);
            Long id = redoMap.size() + 1;
            RedoStatement statement = new RedoStatement();
            statement.setId(id);
            statement.setQueueName(this.queueName);
            statement.setJob(job);
            statement.setAction("store");
            redoMap.put((Object)id, (Object)statement);
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC179I, statement.toString());
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC180E, ex);
        }
        finally {
            redoMap.unlockMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String jobId) {
        IMap redoMap = Main.HAZELCAST.getMap("org.pepstock.jem.redo");
        try {
            redoMap.lockMap(10L, TimeUnit.SECONDS);
            Long id = redoMap.size() + 1;
            RedoStatement statement = new RedoStatement();
            statement.setId(id);
            statement.setQueueName(this.queueName);
            statement.setJobId(jobId);
            statement.setAction("delete");
            redoMap.put((Object)id, (Object)statement);
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC179I, statement.toString());
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC180E, ex);
        }
        finally {
            redoMap.unlockMap();
        }
    }
}

