/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.persistence;

import com.hazelcast.core.IMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.FilenameUtils;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.Main;
import org.pepstock.jem.node.NodeInfoUtility;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.persistence.InputMapManager;
import org.pepstock.jem.node.persistence.JobDBManager;
import org.pepstock.jem.node.persistence.JobMapManager;
import org.pepstock.jem.node.persistence.OutputMapManager;
import org.pepstock.jem.node.persistence.RedoStatement;
import org.pepstock.jem.node.persistence.RoutingMapManager;
import org.pepstock.jem.node.persistence.RunningMapManager;

public class RecoveryManager {
    private static final RecoveryManager INSTANCE = new RecoveryManager();

    private RecoveryManager() {
        String className = FilenameUtils.getExtension((String)this.getClass().getName());
        Timer timer = new Timer(className, false);
        timer.schedule((TimerTask)new PersistenceHealthCheck(), 1L, 15000L);
    }

    public static RecoveryManager getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean applyRedoStatements() throws Exception {
        IMap redoMap = Main.HAZELCAST.getMap("org.pepstock.jem.redo");
        try {
            redoMap.lockMap(10L, TimeUnit.SECONDS);
            if (redoMap.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            ArrayList values = new ArrayList(redoMap.values());
            Collections.sort(values, new Comparator<RedoStatement>(){

                @Override
                public int compare(RedoStatement arg0, RedoStatement arg1) {
                    return arg0.getId().compareTo(arg1.getId());
                }
            });
            for (RedoStatement statement : values) {
                JobMapManager mapStore = null;
                if (statement.getQueueName().equalsIgnoreCase("org.pepstock.jem.input")) {
                    mapStore = InputMapManager.getInstance();
                } else if (statement.getQueueName().equalsIgnoreCase("org.pepstock.jem.running")) {
                    mapStore = RunningMapManager.getInstance();
                } else if (statement.getQueueName().equalsIgnoreCase("org.pepstock.jem.output")) {
                    mapStore = OutputMapManager.getInstance();
                } else if (statement.getQueueName().equalsIgnoreCase("org.pepstock.jem.routing")) {
                    mapStore = RoutingMapManager.getInstance();
                }
                if (statement.getAction().equalsIgnoreCase("store")) {
                    mapStore.store(statement.getJob().getId(), statement.getJob(), true);
                } else if (statement.getAction().equalsIgnoreCase("delete")) {
                    mapStore.delete(statement.getJobId(), true);
                }
                redoMap.remove((Object)statement.getId());
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC176I, statement.toString());
            }
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC177I, String.valueOf(values.size()));
            boolean bl = true;
            return bl;
        }
        finally {
            redoMap.unlockMap();
        }
    }

    class PersistenceHealthCheck
    extends TimerTask {
        PersistenceHealthCheck() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (Main.IS_SHUTTING_DOWN) {
                return;
            }
            ReentrantLock l = Main.NODE.getLock();
            try {
                l.lock();
                if (Main.NODE.isOperational()) {
                    IMap redoMap = Main.HAZELCAST.getMap("org.pepstock.jem.redo");
                    if (!redoMap.isEmpty()) {
                        RecoveryManager.this.applyRedoStatements();
                    }
                    return;
                }
                if (RecoveryManager.this.applyRedoStatements()) {
                    Main.NODE.setOperational(true);
                    NodeInfoUtility.storeNodeInfo(Main.NODE);
                    NodeInfoUtility.start();
                    LogAppl.getInstance().emit(NodeMessage.JEMC172I);
                } else {
                    JobDBManager.getInstance().getInputQueueJobSize();
                    JobDBManager.getInstance().getOutputQueueJobSize();
                    JobDBManager.getInstance().getRoutingQueueJobSize();
                    Main.NODE.setOperational(true);
                    NodeInfoUtility.storeNodeInfo(Main.NODE);
                    NodeInfoUtility.start();
                    LogAppl.getInstance().emit(NodeMessage.JEMC172I);
                }
            }
            catch (Exception e) {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC178E, e);
            }
            finally {
                l.unlock();
            }
        }
    }
}

