/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.persistence;

import com.thoughtworks.xstream.XStream;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.pepstock.jem.PreJob;
import org.pepstock.jem.node.persistence.DBPoolManager;
import org.pepstock.jem.node.persistence.SQLContainer;

public class PreJobDBManager {
    private static final PreJobDBManager INSTANCE = new PreJobDBManager();
    private XStream xs = new XStream();
    private SQLContainer checkingSqlContainer = null;

    private PreJobDBManager() {
    }

    public SQLContainer getCheckingSqlContainer() {
        return this.checkingSqlContainer;
    }

    public void setCheckingSqlContainer(SQLContainer checkingSqlContainer) {
        this.checkingSqlContainer = checkingSqlContainer;
    }

    public static synchronized PreJobDBManager getInstance() {
        return INSTANCE;
    }

    public static boolean isInstanciated() {
        return INSTANCE != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String delete, Long prejobid) throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            PreparedStatement updateStmt = connection.prepareStatement(delete);
            updateStmt.setLong(1, prejobid);
            updateStmt.executeUpdate();
            updateStmt.close();
            connection.commit();
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(String insert, PreJob prejob, Long id) throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            StringReader reader = new StringReader(this.xs.toXML((Object)prejob));
            PreparedStatement updateStmt = connection.prepareStatement(insert);
            updateStmt.setLong(1, id);
            updateStmt.setCharacterStream(2, reader);
            updateStmt.executeUpdate();
            updateStmt.close();
            connection.commit();
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String update, PreJob prejob, Long id) throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            StringReader reader = new StringReader(this.xs.toXML((Object)prejob));
            PreparedStatement updateStmt = connection.prepareStatement(update);
            updateStmt.setCharacterStream(1, reader);
            updateStmt.setLong(2, id);
            updateStmt.executeUpdate();
            updateStmt.close();
            connection.commit();
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Long> getAllPreJobIds(String query) throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            HashSet<Long> allIds = new HashSet<Long>();
            while (rs.next()) {
                allIds.add(Long.parseLong(rs.getObject(1).toString()));
            }
            rs.close();
            stmt.close();
            HashSet<Long> hashSet = allIds;
            return hashSet;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<Long, PreJob> getAllPreJobs(String query) throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            HashMap<Long, PreJob> allPreJobs = new HashMap<Long, PreJob>();
            while (rs.next()) {
                Long prejobid = (Long)rs.getObject(1);
                PreJob job = (PreJob)this.xs.fromXML(rs.getCharacterStream(2));
                allPreJobs.put(prejobid, job);
            }
            rs.close();
            stmt.close();
            HashMap<Long, PreJob> hashMap = allPreJobs;
            return hashMap;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreJob getPreJob(String query, Long prejobid) throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            PreparedStatement stmt = connection.prepareStatement(query);
            stmt.setLong(1, prejobid);
            ResultSet rs = stmt.executeQuery();
            PreJob prejob = null;
            if (rs.next()) {
                prejob = (PreJob)this.xs.fromXML(rs.getCharacterStream(1));
            }
            rs.close();
            stmt.close();
            PreJob preJob = prejob;
            return preJob;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPreJobsCheckingQueueJobSize() throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery(this.checkingSqlContainer.getCheckQueueSizeStatement());
            rs.next();
            long size = rs.getLong(1);
            rs.close();
            stmt.close();
            long l = size;
            return l;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }
}

