/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.persistence;

import com.hazelcast.core.MapStore;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.pepstock.jem.Job;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.Main;
import org.pepstock.jem.node.NodeInfoUtility;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.persistence.JobDBManager;
import org.pepstock.jem.node.persistence.RecoveryManager;
import org.pepstock.jem.node.persistence.RedoManager;
import org.pepstock.jem.node.persistence.SQLContainer;

public class JobMapManager
implements MapStore<String, Job> {
    private String queueName = null;
    private JobDBManager dbManager = null;
    private SQLContainer sqlContainer = null;
    private RedoManager redoManager = null;

    public JobMapManager(String queueName) {
        this.queueName = queueName;
        this.redoManager = new RedoManager(queueName);
        this.dbManager = JobDBManager.getInstance();
    }

    public String getQueueName() {
        return this.queueName;
    }

    public RedoManager getRedoManager() {
        return this.redoManager;
    }

    public void setRedoManager(RedoManager redoManager) {
        this.redoManager = redoManager;
    }

    public SQLContainer getSqlContainer() {
        return this.sqlContainer;
    }

    public void setSqlContainer(SQLContainer sqlContainer) {
        this.sqlContainer = sqlContainer;
    }

    public JobDBManager getDbManager() {
        return this.dbManager;
    }

    public Job load(String jobid) {
        Job job = null;
        try {
            job = this.dbManager.getJob(this.sqlContainer.getGetStatement(), jobid);
        }
        catch (SQLException e) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC043E, e);
            throw new RuntimeException(e);
        }
        return job;
    }

    public Map<String, Job> loadAll(Collection<String> jobids) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> iter = jobids.iterator();
        while (true) {
            String jobid = iter.next();
            sb.append("'").append(jobid).append("'");
            if (!iter.hasNext()) break;
            sb.append(", ");
        }
        String sqlString = MessageFormat.format(this.sqlContainer.getGetAllStatement(), sb.toString());
        HashMap<String, Job> jobs = null;
        try {
            jobs = this.dbManager.getAllJobs(sqlString);
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC048I, String.valueOf(jobs.size()), this.getQueueName());
        }
        catch (SQLException e) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC043E, e);
            throw new RuntimeException(e);
        }
        return jobs;
    }

    public Set<String> loadAllKeys() {
        Set<String> set = null;
        try {
            set = this.dbManager.getAllJobIds(this.sqlContainer.getGetAllKeysStatement());
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC045I, String.valueOf(set.size()), this.getQueueName());
        }
        catch (SQLException e) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC043E, e);
            throw new RuntimeException(e);
        }
        return set;
    }

    public void delete(String jobid) {
        this.delete(jobid, false);
    }

    public void deleteAll(Collection<String> ids) {
        for (String id : ids) {
            this.delete(id);
        }
    }

    public void store(String jobid, Job job) {
        this.store(jobid, job, false);
    }

    public void storeAll(Map<String, Job> jobs) {
        for (Job job : jobs.values()) {
            this.store(job.getId(), job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String jobid, boolean exception) {
        block13: {
            try {
                this.dbManager.delete(this.sqlContainer.getDeleteStatement(), jobid);
                if (exception) break block13;
                ReentrantLock l = Main.NODE.getLock();
                try {
                    l.lock();
                    if (!Main.NODE.isOperational()) {
                        RecoveryManager.getInstance().applyRedoStatements();
                        Main.NODE.setOperational(true);
                        NodeInfoUtility.storeNodeInfo(Main.NODE);
                        NodeInfoUtility.start();
                        LogAppl.getInstance().emit(NodeMessage.JEMC172I);
                    }
                }
                catch (Exception e) {
                    LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC043E, e);
                }
                finally {
                    l.unlock();
                }
            }
            catch (SQLException e) {
                if (exception) {
                    throw new RuntimeException(e);
                }
                ReentrantLock l = Main.NODE.getLock();
                try {
                    l.lock();
                    this.redoManager.delete(jobid);
                    if (Main.NODE.isOperational()) {
                        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC043E, e);
                        Main.NODE.setOperational(false);
                        NodeInfoUtility.storeNodeInfo(Main.NODE);
                        NodeInfoUtility.drain();
                        LogAppl.getInstance().emit(NodeMessage.JEMC173E);
                    }
                }
                finally {
                    l.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(String jobid, Job job, boolean exception) {
        block21: {
            try {
                this.dbManager.insert(this.sqlContainer.getInsertStatement(), job);
                if (exception) break block21;
                ReentrantLock l = Main.NODE.getLock();
                try {
                    l.lock();
                    if (!Main.NODE.isOperational()) {
                        RecoveryManager.getInstance().applyRedoStatements();
                        Main.NODE.setOperational(true);
                        NodeInfoUtility.storeNodeInfo(Main.NODE);
                        NodeInfoUtility.start();
                        LogAppl.getInstance().emit(NodeMessage.JEMC172I);
                    }
                }
                catch (Exception e) {
                    LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC043E, e);
                }
                finally {
                    l.unlock();
                }
            }
            catch (SQLException e1) {
                try {
                    this.dbManager.update(this.sqlContainer.getUpdateStatement(), job);
                    if (exception) break block21;
                    ReentrantLock l = Main.NODE.getLock();
                    try {
                        l.lock();
                        if (!Main.NODE.isOperational()) {
                            RecoveryManager.getInstance().applyRedoStatements();
                            Main.NODE.setOperational(true);
                            NodeInfoUtility.storeNodeInfo(Main.NODE);
                            NodeInfoUtility.start();
                            LogAppl.getInstance().emit(NodeMessage.JEMC172I);
                        }
                    }
                    catch (Exception e2) {
                        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC043E, e2);
                    }
                    finally {
                        l.unlock();
                    }
                }
                catch (SQLException e3) {
                    if (exception) {
                        throw new RuntimeException(e3);
                    }
                    ReentrantLock l = Main.NODE.getLock();
                    try {
                        l.lock();
                        this.redoManager.store(job);
                        if (Main.NODE.isOperational()) {
                            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC043E, e3);
                            Main.NODE.setOperational(false);
                            NodeInfoUtility.storeNodeInfo(Main.NODE);
                            NodeInfoUtility.drain();
                            LogAppl.getInstance().emit(NodeMessage.JEMC173E);
                        }
                    }
                    finally {
                        l.unlock();
                    }
                }
            }
        }
    }
}

