/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.persistence;

import com.thoughtworks.xstream.XStream;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.pepstock.jem.Job;
import org.pepstock.jem.node.persistence.DBPoolManager;
import org.pepstock.jem.node.persistence.SQLContainer;

public class JobDBManager {
    private static final JobDBManager INSTANCE = new JobDBManager();
    private XStream xs = new XStream();
    private SQLContainer inputSqlContainer = null;
    private SQLContainer outputSqlContainer = null;
    private SQLContainer routingSqlContainer = null;
    private SQLContainer runningSqlContainer = null;

    private JobDBManager() {
    }

    public SQLContainer getInputSqlContainer() {
        return this.inputSqlContainer;
    }

    public void setInputSqlContainer(SQLContainer inputSqlContainer) {
        this.inputSqlContainer = inputSqlContainer;
    }

    public SQLContainer getOutputSqlContainer() {
        return this.outputSqlContainer;
    }

    public void setOutputSqlContainer(SQLContainer outputSqlContainer) {
        this.outputSqlContainer = outputSqlContainer;
    }

    public SQLContainer getRoutingSqlContainer() {
        return this.routingSqlContainer;
    }

    public void setRoutingSqlContainer(SQLContainer routingSqlContainer) {
        this.routingSqlContainer = routingSqlContainer;
    }

    public SQLContainer getRunningSqlContainer() {
        return this.runningSqlContainer;
    }

    public void setRunningSqlContainer(SQLContainer runningSqlContainer) {
        this.runningSqlContainer = runningSqlContainer;
    }

    public static synchronized JobDBManager getInstance() {
        return INSTANCE;
    }

    public static boolean isInstanciated() {
        return INSTANCE != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String delete, String jobid) throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            PreparedStatement updateStmt = connection.prepareStatement(delete);
            updateStmt.setString(1, jobid);
            updateStmt.executeUpdate();
            updateStmt.close();
            connection.commit();
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(String insert, Job job) throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            StringReader reader = new StringReader(this.xs.toXML((Object)job));
            PreparedStatement updateStmt = connection.prepareStatement(insert);
            updateStmt.setString(1, job.getId());
            updateStmt.setCharacterStream(2, reader);
            updateStmt.executeUpdate();
            updateStmt.close();
            connection.commit();
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String update, Job job) throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            StringReader reader = new StringReader(this.xs.toXML((Object)job));
            PreparedStatement updateStmt = connection.prepareStatement(update);
            updateStmt.setCharacterStream(1, reader);
            updateStmt.setString(2, job.getId());
            updateStmt.executeUpdate();
            updateStmt.close();
            connection.commit();
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAllJobIds(String query) throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            HashSet<String> allIds = new HashSet<String>();
            while (rs.next()) {
                allIds.add(rs.getObject(1).toString());
            }
            rs.close();
            stmt.close();
            HashSet<String> hashSet = allIds;
            return hashSet;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Job> getAllJobs(String query) throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            HashMap<String, Job> allJobs = new HashMap<String, Job>();
            while (rs.next()) {
                Job job = (Job)this.xs.fromXML(rs.getCharacterStream(1));
                allJobs.put(job.getId(), job);
            }
            rs.close();
            stmt.close();
            HashMap<String, Job> hashMap = allJobs;
            return hashMap;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Job getJob(String query, String jobid) throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            PreparedStatement stmt = connection.prepareStatement(query);
            stmt.setString(1, jobid);
            ResultSet rs = stmt.executeQuery();
            Job job = null;
            if (rs.next()) {
                job = (Job)this.xs.fromXML(rs.getCharacterStream(1));
            }
            rs.close();
            stmt.close();
            Job job2 = job;
            return job2;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getInputQueueJobSize() throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery(this.inputSqlContainer.getCheckQueueSizeStatement());
            rs.next();
            long size = rs.getLong(1);
            rs.close();
            stmt.close();
            long l = size;
            return l;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRunningQueueJobSize() throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery(this.runningSqlContainer.getCheckQueueSizeStatement());
            rs.next();
            long size = rs.getLong(1);
            rs.close();
            stmt.close();
            long l = size;
            return l;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getOutputQueueJobSize() throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery(this.outputSqlContainer.getCheckQueueSizeStatement());
            rs.next();
            long size = rs.getLong(1);
            rs.close();
            stmt.close();
            long l = size;
            return l;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRoutingQueueJobSize() throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery(this.routingSqlContainer.getCheckQueueSizeStatement());
            rs.next();
            long size = rs.getLong(1);
            rs.close();
            stmt.close();
            long l = size;
            return l;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }
}

