/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.persistence;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.commons.dbcp.BasicDataSource;

public class DBPoolManager {
    private static final DBPoolManager POOL_MANAGER = new DBPoolManager();
    private String driver = null;
    private String url = null;
    private String user = null;
    private String password = null;
    private Properties properties = null;
    private String keepAliveConnectionSQL = null;
    private BasicDataSource pool = null;

    private DBPoolManager() {
    }

    public static DBPoolManager getInstance() {
        return POOL_MANAGER;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String userid) {
        this.user = userid;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getKeepAliveConnectionSQL() {
        return this.keepAliveConnectionSQL;
    }

    public void setKeepAliveConnectionSQL(String testConnectionSQL) {
        this.keepAliveConnectionSQL = testConnectionSQL;
    }

    public void init() throws SQLException {
        if (this.pool == null) {
            this.pool = new BasicDataSource();
            this.pool.setDriverClassName(this.driver);
            this.pool.setUrl(this.url);
            this.pool.setUsername(this.user);
            this.pool.setPassword(this.password);
            if (this.properties != null && !this.properties.isEmpty()) {
                for (Object key : this.properties.keySet()) {
                    String value = this.properties.getProperty(key.toString());
                    this.pool.addConnectionProperty(key.toString(), value);
                }
            }
            this.pool.setDefaultAutoCommit(false);
            this.pool.setInitialSize(5);
            this.pool.setMaxActive(10);
            this.pool.setMaxIdle(5);
            if (this.keepAliveConnectionSQL != null) {
                this.pool.setValidationQuery(this.keepAliveConnectionSQL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void create(String create) throws SQLException {
        Connection connection = this.getConnection();
        try {
            Statement stmt = connection.createStatement();
            stmt.executeUpdate(create);
            stmt.close();
            connection.commit();
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    public Connection getConnection() throws SQLException {
        return this.pool.getConnection();
    }

    public void close() throws SQLException {
        this.pool.close();
    }
}

