/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.persistence;

import com.hazelcast.core.MapStore;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.persistence.CommonResourcesDBManager;
import org.pepstock.jem.node.persistence.SQLContainer;
import org.pepstock.jem.node.resources.Resource;

public class CommonResourcesMapManager
implements MapStore<String, Resource> {
    private CommonResourcesDBManager dbManager = CommonResourcesDBManager.getInstance();
    private SQLContainer sql = this.dbManager.getCommonResourcesSqlContainer();

    public Resource load(String resourceName) {
        if (this.dbManager == null) {
            LogAppl.getInstance().emit(NodeMessage.JEMC044E);
            throw new RuntimeException(NodeMessage.JEMC044E.toMessage().getMessage());
        }
        Resource resource = null;
        try {
            resource = this.dbManager.getResource(this.sql.getGetStatement(), resourceName);
        }
        catch (SQLException e) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC043E, e);
            throw new RuntimeException(e);
        }
        return resource;
    }

    public Set<String> loadAllKeys() {
        if (this.dbManager == null) {
            LogAppl.getInstance().emit(NodeMessage.JEMC044E);
            throw new RuntimeException(NodeMessage.JEMC044E.toMessage().getMessage());
        }
        Set<String> set = null;
        try {
            set = this.dbManager.getAllResourceNames(this.sql.getGetAllKeysStatement());
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC045I, String.valueOf(set.size()), "org.pepstock.jem.common.resources");
        }
        catch (SQLException e) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC043E, e);
            throw new RuntimeException(e);
        }
        return set;
    }

    public void delete(String resourceName) {
        if (this.dbManager == null) {
            LogAppl.getInstance().emit(NodeMessage.JEMC044E);
            throw new RuntimeException(NodeMessage.JEMC044E.toMessage().getMessage());
        }
        try {
            this.dbManager.delete(this.sql.getDeleteStatement(), resourceName);
        }
        catch (SQLException e) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC043E, e);
            throw new RuntimeException(e);
        }
    }

    public void store(String resourceName, Resource resource) {
        if (this.dbManager == null) {
            LogAppl.getInstance().emit(NodeMessage.JEMC044E);
            throw new RuntimeException(NodeMessage.JEMC044E.toMessage().getMessage());
        }
        try {
            this.dbManager.insert(this.sql.getInsertStatement(), resource);
        }
        catch (SQLException e) {
            try {
                this.dbManager.update(this.sql.getUpdateStatement(), resource);
            }
            catch (SQLException e1) {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC043E, e1);
                throw new RuntimeException(e1);
            }
        }
    }

    public void storeAll(Map<String, Resource> map) {
        if (this.dbManager == null) {
            LogAppl.getInstance().emit(NodeMessage.JEMC044E);
            throw new RuntimeException(NodeMessage.JEMC044E.toMessage().getMessage());
        }
        for (Resource resource : map.values()) {
            try {
                this.dbManager.insert(this.sql.getInsertStatement(), resource);
            }
            catch (SQLException e) {
                try {
                    this.dbManager.update(this.sql.getUpdateStatement(), resource);
                }
                catch (SQLException e1) {
                    LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC043E, e1);
                    throw new RuntimeException(e1);
                }
            }
        }
    }

    public void deleteAll(Collection<String> names) {
        if (this.dbManager == null) {
            LogAppl.getInstance().emit(NodeMessage.JEMC044E);
            throw new RuntimeException(NodeMessage.JEMC044E.toMessage().getMessage());
        }
        for (String name : names) {
            try {
                this.dbManager.delete(this.sql.getDeleteStatement(), name);
            }
            catch (SQLException e) {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC043E, e);
                throw new RuntimeException(e);
            }
        }
    }

    public Map<String, Resource> loadAll(Collection<String> resourceNames) {
        if (this.dbManager == null) {
            LogAppl.getInstance().emit(NodeMessage.JEMC044E);
            throw new RuntimeException(NodeMessage.JEMC044E.toMessage().getMessage());
        }
        StringBuilder sb = new StringBuilder();
        Iterator<String> iter = resourceNames.iterator();
        while (true) {
            String resourceName = iter.next();
            sb.append("'").append(resourceName).append("'");
            if (!iter.hasNext()) break;
            sb.append(", ");
        }
        String sqlString = MessageFormat.format(this.sql.getGetAllStatement(), sb.toString());
        HashMap<String, Resource> resources = null;
        try {
            resources = this.dbManager.getAllResources(sqlString);
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC055I, String.valueOf(resources.size()), "org.pepstock.jem.common.resources");
        }
        catch (SQLException e) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC043E, e);
            throw new RuntimeException(e);
        }
        return resources;
    }
}

