/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.persistence;

import com.thoughtworks.xstream.XStream;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.pepstock.jem.node.persistence.DBPoolManager;
import org.pepstock.jem.node.persistence.SQLContainer;
import org.pepstock.jem.node.resources.Resource;
import org.pepstock.jem.node.resources.XmlUtil;

public class CommonResourcesDBManager {
    private static final CommonResourcesDBManager INSTANCE = new CommonResourcesDBManager();
    private XStream xs = XmlUtil.getXStream();
    private SQLContainer commonResourcesSqlContainer = null;

    private CommonResourcesDBManager() {
    }

    public SQLContainer getCommonResourcesSqlContainer() {
        return this.commonResourcesSqlContainer;
    }

    public void setCommonResourcesSqlContainer(SQLContainer commonResourcesSqlContainer) {
        this.commonResourcesSqlContainer = commonResourcesSqlContainer;
    }

    public static synchronized CommonResourcesDBManager getInstance() {
        return INSTANCE;
    }

    public static boolean isInstanciated() {
        return INSTANCE != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String delete, String resourceName) throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            PreparedStatement updateStmt = connection.prepareStatement(delete);
            updateStmt.setString(1, resourceName);
            updateStmt.executeUpdate();
            updateStmt.close();
            connection.commit();
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(String insert, Resource resource) throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            StringReader reader = new StringReader(this.xs.toXML((Object)resource));
            PreparedStatement updateStmt = connection.prepareStatement(insert);
            updateStmt.setString(1, resource.getName());
            updateStmt.setCharacterStream(2, reader);
            updateStmt.executeUpdate();
            updateStmt.close();
            connection.commit();
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String update, Resource resource) throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            StringReader reader = new StringReader(this.xs.toXML((Object)resource));
            PreparedStatement updateStmt = connection.prepareStatement(update);
            updateStmt.setCharacterStream(1, reader);
            updateStmt.setString(2, resource.getName());
            updateStmt.executeUpdate();
            updateStmt.close();
            connection.commit();
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAllResourceNames(String query) throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            HashSet<String> allIds = new HashSet<String>();
            while (rs.next()) {
                allIds.add(rs.getObject(1).toString());
            }
            rs.close();
            stmt.close();
            HashSet<String> hashSet = allIds;
            return hashSet;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Resource> getAllResources(String query) throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            HashMap<String, Resource> allResources = new HashMap<String, Resource>();
            while (rs.next()) {
                Resource resource = (Resource)this.xs.fromXML(rs.getCharacterStream(1));
                allResources.put(resource.getName(), resource);
            }
            rs.close();
            stmt.close();
            HashMap<String, Resource> hashMap = allResources;
            return hashMap;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getResource(String query, String resourceName) throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            PreparedStatement stmt = connection.prepareStatement(query);
            stmt.setString(1, resourceName);
            ResultSet rs = stmt.executeQuery();
            Resource resource = null;
            if (rs.next()) {
                resource = (Resource)this.xs.fromXML(rs.getCharacterStream(1));
            }
            rs.close();
            stmt.close();
            Resource resource2 = resource;
            return resource2;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCommonResourcesSize() throws SQLException {
        Connection connection = DBPoolManager.getInstance().getConnection();
        try {
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery(this.commonResourcesSqlContainer.getCheckQueueSizeStatement());
            rs.next();
            long size = rs.getLong(1);
            rs.close();
            stmt.close();
            long l = size;
            return l;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }
}

