/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.persistence;

import com.hazelcast.core.MapStore;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.pepstock.jem.PreJob;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.persistence.PreJobDBManager;
import org.pepstock.jem.node.persistence.SQLContainer;

public class CheckingMapManager
implements MapStore<Long, PreJob> {
    private PreJobDBManager dbManager = PreJobDBManager.getInstance();
    private SQLContainer sql = this.dbManager.getCheckingSqlContainer();

    public PreJob load(Long jobid) {
        if (this.dbManager == null) {
            LogAppl.getInstance().emit(NodeMessage.JEMC044E);
            throw new RuntimeException(NodeMessage.JEMC044E.toMessage().getMessage());
        }
        PreJob prejob = null;
        try {
            prejob = this.dbManager.getPreJob(this.sql.getGetStatement(), jobid);
        }
        catch (SQLException e) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC043E, e);
            throw new RuntimeException(e);
        }
        return prejob;
    }

    public Set<Long> loadAllKeys() {
        if (this.dbManager == null) {
            LogAppl.getInstance().emit(NodeMessage.JEMC044E);
            throw new RuntimeException(NodeMessage.JEMC044E.toMessage().getMessage());
        }
        Set<Long> set = null;
        try {
            set = this.dbManager.getAllPreJobIds(this.sql.getGetAllKeysStatement());
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC045I, String.valueOf(set.size()), "org.pepstock.jem.jcl.checking");
        }
        catch (SQLException e) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC043E, e);
            throw new RuntimeException(e);
        }
        return set;
    }

    public void delete(Long prejobid) {
        if (this.dbManager == null) {
            LogAppl.getInstance().emit(NodeMessage.JEMC044E);
            throw new RuntimeException(NodeMessage.JEMC044E.toMessage().getMessage());
        }
        try {
            this.dbManager.delete(this.sql.getDeleteStatement(), prejobid);
        }
        catch (SQLException e) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC043E, e);
            throw new RuntimeException(e);
        }
    }

    public void store(Long prejobid, PreJob prejob) {
        if (this.dbManager == null) {
            LogAppl.getInstance().emit(NodeMessage.JEMC044E);
            throw new RuntimeException(NodeMessage.JEMC044E.toMessage().getMessage());
        }
        try {
            this.dbManager.insert(this.sql.getInsertStatement(), prejob, prejobid);
        }
        catch (SQLException e) {
            try {
                this.dbManager.update(this.sql.getUpdateStatement(), prejob, prejobid);
            }
            catch (SQLException e1) {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC043E, e1);
                throw new RuntimeException(e1);
            }
        }
    }

    public void storeAll(Map<Long, PreJob> map) {
        if (this.dbManager == null) {
            LogAppl.getInstance().emit(NodeMessage.JEMC044E);
            throw new RuntimeException(NodeMessage.JEMC044E.toMessage().getMessage());
        }
        for (Map.Entry<Long, PreJob> entry : map.entrySet()) {
            PreJob prejob = entry.getValue();
            Long key = entry.getKey();
            try {
                this.dbManager.insert(this.sql.getInsertStatement(), prejob, key);
            }
            catch (SQLException e) {
                try {
                    this.dbManager.update(this.sql.getUpdateStatement(), prejob, key);
                }
                catch (SQLException e1) {
                    LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC043E, e1);
                    throw new RuntimeException(e1);
                }
            }
        }
    }

    public void deleteAll(Collection<Long> ids) {
        if (this.dbManager == null) {
            LogAppl.getInstance().emit(NodeMessage.JEMC044E);
            throw new RuntimeException(NodeMessage.JEMC044E.toMessage().getMessage());
        }
        for (Long id : ids) {
            try {
                this.dbManager.delete(this.sql.getDeleteStatement(), id);
            }
            catch (SQLException e) {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC043E, e);
                throw new RuntimeException(e);
            }
        }
    }

    public Map<Long, PreJob> loadAll(Collection<Long> collection) {
        if (this.dbManager == null) {
            LogAppl.getInstance().emit(NodeMessage.JEMC044E);
            throw new RuntimeException(NodeMessage.JEMC044E.toMessage().getMessage());
        }
        StringBuilder sb = new StringBuilder();
        for (Long jobid : collection) {
            sb.append("'").append(jobid).append("'").append(", ");
        }
        String inStmt = StringUtils.substringBeforeLast((String)sb.toString(), (String)",");
        String sqlString = MessageFormat.format(this.sql.getGetAllStatement(), inStmt);
        HashMap<Long, PreJob> prejobs = null;
        try {
            prejobs = this.dbManager.getAllPreJobs(sqlString);
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC048I, String.valueOf(prejobs.size()), "org.pepstock.jem.jcl.checking");
        }
        catch (SQLException e) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC043E, e);
            throw new RuntimeException(e);
        }
        return prejobs;
    }
}

