/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.listeners;

import com.hazelcast.core.Cluster;
import com.hazelcast.core.IMap;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import java.util.Date;
import org.pepstock.jem.Job;
import org.pepstock.jem.Result;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.Main;
import org.pepstock.jem.node.NodeInfo;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.RequestLock;
import org.pepstock.jem.node.Status;
import org.pepstock.jem.node.events.JobLifecycleEvent;

public class NodeListener
implements MembershipListener {
    public void memberAdded(MembershipEvent event) {
    }

    public void memberRemoved(MembershipEvent event) {
        if (Main.IS_SHUTTING_DOWN) {
            return;
        }
        Cluster cluster = Main.HAZELCAST.getCluster();
        Member local = cluster.getLocalMember();
        for (Member member : cluster.getMembers()) {
            if (member.isLiteMember()) continue;
            if (!local.equals(member)) {
                return;
            }
            this.actionsForCoordinator(event);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actionsForCoordinator(MembershipEvent event) {
        String key;
        Main.IS_COORDINATOR = true;
        Member memberRemoved = event.getMember();
        IMap members_map = Main.HAZELCAST.getMap("org.pepstock.jem.nodes");
        if (members_map.containsKey((Object)(key = memberRemoved.getUuid()))) {
            try {
                members_map.lock((Object)key);
                NodeInfo info = (NodeInfo)members_map.get((Object)key);
                info.setStatus(Status.UNKNOWN);
                if (!memberRemoved.isLiteMember()) {
                    RequestLock request = info.getRequest();
                    if (request != null && !request.getResources().isEmpty()) {
                        info.unlockForFailover();
                        request.getResources().clear();
                    }
                    if (info.getJob() != null) {
                        this.jobEnded(info.getJob());
                    }
                }
                members_map.replace((Object)info.getKey(), (Object)info);
            }
            catch (Exception ex) {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC174E, ex);
            }
            finally {
                members_map.unlock((Object)key);
            }
        } else {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC024E, memberRemoved.toString(), "org.pepstock.jem.nodes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jobEnded(Job job) {
        Result result = new Result();
        result.setReturnCode(12);
        result.setExceptionMessage("Node is crashed during job was executing");
        job.setResult(result);
        job.setEndedTime(new Date());
        job.setRunningStatus(0);
        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC021I, job.toString(), String.valueOf(job.getResult().getReturnCode()));
        IMap runningQueue = Main.HAZELCAST.getMap("org.pepstock.jem.running");
        IMap outputQueue = Main.HAZELCAST.getMap("org.pepstock.jem.output");
        try {
            runningQueue.lock((Object)job.getId());
            outputQueue.lock((Object)job.getId());
            runningQueue.remove((Object)job.getId());
            outputQueue.put((Object)job.getId(), (Object)job);
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC175E, ex, job.getName());
        }
        finally {
            runningQueue.unlock((Object)job.getId());
            outputQueue.unlock((Object)job.getId());
        }
        Main.JOB_LIFECYCLE_LISTENERS_SYSTEM.addJobLifecycleEvent(new JobLifecycleEvent("org.pepstock.jem.output", job));
        ITopic topic = Main.HAZELCAST.getTopic("org.pepstock.jem.job.ended");
        topic.publish((Object)job);
    }
}

