/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.executors.stats;

import com.hazelcast.monitor.LocalMapOperationStats;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.monitor.LocalQueueOperationStats;
import com.hazelcast.monitor.LocalQueueStats;
import java.lang.management.ManagementFactory;
import org.hyperic.sigar.Cpu;
import org.hyperic.sigar.FileSystemUsage;
import org.hyperic.sigar.Mem;
import org.hyperic.sigar.ProcCpu;
import org.hyperic.sigar.ProcMem;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.Main;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.executors.DefaultExecutor;
import org.pepstock.jem.node.stats.CpuUtilization;
import org.pepstock.jem.node.stats.FileSystemUtilization;
import org.pepstock.jem.node.stats.LightMapStats;
import org.pepstock.jem.node.stats.LightMemberSample;
import org.pepstock.jem.node.stats.MapOperationsStats;
import org.pepstock.jem.node.stats.MapStats;
import org.pepstock.jem.node.stats.MemberSample;
import org.pepstock.jem.node.stats.MemoryUtilization;
import org.pepstock.jem.node.stats.ProcessCpuUtilization;
import org.pepstock.jem.node.stats.ProcessMemoryUtilization;
import org.pepstock.jem.node.stats.QueueOperationsStats;
import org.pepstock.jem.node.stats.QueueStats;
import org.pepstock.jem.node.stats.Sample;

public class GetSample
extends DefaultExecutor<LightMemberSample> {
    private static final long serialVersionUID = 1L;
    private Sample newSample = null;

    public GetSample(Sample newSample) {
        this.newSample = newSample;
    }

    @Override
    public LightMemberSample call() throws Exception {
        try {
            this.checkShutDown();
        }
        catch (Exception ex) {
            return null;
        }
        if (Main.NODE == null) {
            return null;
        }
        if (Main.STATISTICS_MANAGER == null) {
            return null;
        }
        Sigar sigar = new Sigar();
        MemberSample member_sample = new MemberSample();
        member_sample.setMemberKey(Main.NODE.getKey());
        member_sample.setMemberLabel(Main.NODE.getLabel());
        member_sample.setMemberHostname(Main.NODE.getHostname());
        member_sample.setPid(sigar.getPid());
        MemberSample last_member_sample = Main.STATISTICS_MANAGER.getLastMemberSample();
        member_sample.setNumberOfJCLCheck(last_member_sample == null ? Main.NUMBER_OF_JCL_CHECK : Main.NUMBER_OF_JCL_CHECK - last_member_sample.getTotalNumberOfJCLCheck());
        member_sample.setNumberOfJOBSubmitted(last_member_sample == null ? Main.NUMBER_OF_JOB_SUBMITTED : Main.NUMBER_OF_JOB_SUBMITTED - last_member_sample.getTotalNumberOfJOBSubmitted());
        member_sample.setTotalNumberOfJCLCheck(Main.NUMBER_OF_JCL_CHECK);
        member_sample.setTotalNumberOfJOBSubmitted(Main.NUMBER_OF_JOB_SUBMITTED);
        this.loadCpuUtilization(member_sample, sigar);
        this.loadMemoryUtilization(member_sample, sigar);
        this.loadProcessCpuUtilization(member_sample, sigar);
        this.loadProcessMemoryUtilization(member_sample, sigar);
        this.loadGFSUtilization(member_sample, sigar);
        this.loadHazelcastMapsStats(member_sample);
        this.loadHazelcastQueuesStats(member_sample);
        this.newSample.getMembers().add(member_sample);
        Main.STATISTICS_MANAGER.write(this.newSample);
        Main.STATISTICS_MANAGER.setLastMemberSample(member_sample);
        return this.createLightMemberSample(this.newSample, member_sample);
    }

    private LightMemberSample createLightMemberSample(Sample sample, MemberSample msample) {
        LightMemberSample member_sample = new LightMemberSample();
        member_sample.setMemberKey(msample.getMemberKey());
        member_sample.setMemberLabel(msample.getMemberLabel());
        member_sample.setMemberHostname(msample.getMemberHostname());
        member_sample.setPid(msample.getPid());
        member_sample.setKey(sample.getKey());
        member_sample.setCpuPercent(msample.getCpu().getPercent());
        member_sample.setMemoryAvailable(msample.getMemory().getAvailable());
        member_sample.setMemoryFree(msample.getMemory().getFree());
        member_sample.setNumberOfJCLCheck(msample.getNumberOfJCLCheck());
        member_sample.setNumberOfJOBSubmitted(msample.getNumberOfJOBSubmitted());
        member_sample.setProcessCpuPercent(msample.getProcessCpu().getPercent());
        member_sample.setProcessTotalCpu(msample.getProcessCpu().getTotal());
        member_sample.setProcessMemoryUsed(msample.getProcessMemory().getUsed());
        member_sample.setProcessMemoryFree(msample.getProcessMemory().getFree());
        member_sample.setTime(sample.getTime());
        member_sample.setTotalNumberOfJCLCheck(msample.getTotalNumberOfJCLCheck());
        member_sample.setTotalNumberOfJOBSubmitted(msample.getTotalNumberOfJOBSubmitted());
        member_sample.setGfsFree(msample.getFileSystem().getFree());
        member_sample.setGfsUsed(msample.getFileSystem().getUsed());
        MapStats map = msample.getMapsStats().get("org.pepstock.jem.input");
        member_sample.getMapsStats().put("org.pepstock.jem.input", this.createLightMapStats(map));
        map = msample.getMapsStats().get("org.pepstock.jem.output");
        member_sample.getMapsStats().put("org.pepstock.jem.output", this.createLightMapStats(map));
        map = msample.getMapsStats().get("org.pepstock.jem.running");
        member_sample.getMapsStats().put("org.pepstock.jem.running", this.createLightMapStats(map));
        map = msample.getMapsStats().get("org.pepstock.jem.routing");
        member_sample.getMapsStats().put("org.pepstock.jem.routing", this.createLightMapStats(map));
        return member_sample;
    }

    private LightMapStats createLightMapStats(MapStats map) {
        LightMapStats lmap = new LightMapStats();
        lmap.setHits(map.getHits());
        lmap.setName(map.getName());
        lmap.setNumberOfGets(map.getOperationsStats().getNumberOfGets());
        lmap.setNumberOfPuts(map.getOperationsStats().getNumberOfPuts());
        lmap.setNumberOfRemoves(map.getOperationsStats().getNumberOfRemoves());
        lmap.setOwnedEntryCount(map.getOwnedEntryCount());
        lmap.setOwnedEntryMemoryCost(map.getOwnedEntryMemoryCost());
        lmap.setLockedEntryCount(map.getLockedEntryCount());
        lmap.setLockWaitCount(map.getLockWaitCount());
        lmap.setTotalGetLatency(map.getOperationsStats().getTotalGetLatency());
        lmap.setTotalPutLatency(map.getOperationsStats().getTotalPutLatency());
        lmap.setTotalRemoveLatency(map.getOperationsStats().getTotalRemoveLatency());
        return lmap;
    }

    private void loadCpuUtilization(MemberSample sample, Sigar sigar) {
        try {
            Cpu s_cpu = sigar.getCpu();
            CpuUtilization cpu = sample.getCpu();
            cpu.setIdle(s_cpu.getIdle());
            cpu.setSystem(s_cpu.getSys());
            cpu.setTotal(s_cpu.getTotal());
            cpu.setUser(s_cpu.getUser());
            MemberSample last_member_sample = Main.STATISTICS_MANAGER.getLastMemberSample();
            if (last_member_sample != null) {
                CpuUtilization last_cpu_util = last_member_sample.getCpu();
                long diffTime = sample.getCurrentTimeMillis() - last_member_sample.getCurrentTimeMillis();
                long tot_possible_cpu = diffTime * (long)ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors();
                long cpu_used = cpu.getUser() + cpu.getSystem() - (last_cpu_util.getUser() + last_cpu_util.getSystem());
                double cpu_used_percent = (double)cpu_used * 1.0 / (double)tot_possible_cpu;
                cpu_used_percent = Math.min(Math.max(cpu_used_percent, 0.0), 1.0);
                cpu.setPercent(cpu_used_percent);
            } else {
                long tot_possible_cpu = 60000L * (long)ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors();
                long cpu_used = cpu.getUser() + cpu.getSystem();
                double cpu_used_percent = (double)cpu_used * 1.0 / (double)tot_possible_cpu;
                cpu_used_percent = Math.min(Math.max(cpu_used_percent, 0.0), 1.0);
                cpu.setPercent(cpu_used_percent);
            }
        }
        catch (SigarException e) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC169W, e);
        }
    }

    private void loadMemoryUtilization(MemberSample sample, Sigar sigar) {
        try {
            Mem s_mem = sigar.getMem();
            MemoryUtilization mem = sample.getMemory();
            mem.setAvailable(s_mem.getTotal());
            mem.setUsed(s_mem.getUsed());
            mem.setFree(s_mem.getFree());
        }
        catch (SigarException e) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC169W, e);
        }
    }

    private void loadProcessCpuUtilization(MemberSample sample, Sigar sigar) {
        try {
            ProcCpu s_cpu = sigar.getProcCpu(sample.getPid());
            ProcessCpuUtilization cpu = sample.getProcessCpu();
            cpu.setSystem(s_cpu.getSys());
            cpu.setTotal(s_cpu.getTotal());
            cpu.setUser(s_cpu.getUser());
            MemberSample last_member_sample = Main.STATISTICS_MANAGER.getLastMemberSample();
            if (last_member_sample != null) {
                ProcessCpuUtilization last_cpu_util = last_member_sample.getProcessCpu();
                long diffTime = sample.getCurrentTimeMillis() - last_member_sample.getCurrentTimeMillis();
                long tot_possible_cpu = diffTime * (long)ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors();
                long cpu_used = cpu.getTotal() - last_cpu_util.getTotal();
                double cpu_used_percent = (double)cpu_used * 1.0 / (double)tot_possible_cpu;
                cpu_used_percent = Math.min(Math.max(cpu_used_percent, 0.0), 1.0);
                cpu.setPercent(cpu_used_percent);
            } else {
                long tot_possible_cpu = 60000L * (long)ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors();
                long cpu_used = cpu.getTotal();
                double cpu_used_percent = (double)cpu_used * 1.0 / (double)tot_possible_cpu;
                cpu_used_percent = Math.min(Math.max(cpu_used_percent, 0.0), 1.0);
                cpu.setPercent(cpu_used_percent);
            }
        }
        catch (SigarException e) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC169W, e);
        }
    }

    private void loadProcessMemoryUtilization(MemberSample sample, Sigar sigar) {
        try {
            ProcMem s_mem = sigar.getProcMem(sample.getPid());
            ProcessMemoryUtilization mem = sample.getProcessMemory();
            mem.setAvailable(s_mem.getSize());
            mem.setUsed(s_mem.getResident());
            long free = mem.getAvailable() - mem.getUsed();
            mem.setFree(free);
        }
        catch (SigarException e) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC169W, e);
        }
    }

    private void loadGFSUtilization(MemberSample sample, Sigar sigar) {
        try {
            FileSystemUtilization fsUtil = sample.getFileSystem();
            FileSystemUsage usage = sigar.getFileSystemUsage(Main.OUTPUT_SYSTEM.getOutputPath().getAbsolutePath());
            long free = usage.getFree();
            long total = usage.getTotal();
            long used = usage.getUsed();
            fsUtil.setFree(free);
            fsUtil.setTotal(total);
            fsUtil.setUsed(used);
        }
        catch (SigarException e) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC169W, e);
        }
    }

    private void loadHazelcastMapsStats(MemberSample sample) {
        MapStats input = this.loadMapStats("org.pepstock.jem.input");
        MapStats running = this.loadMapStats("org.pepstock.jem.running");
        MapStats output = this.loadMapStats("org.pepstock.jem.output");
        MapStats routing = this.loadMapStats("org.pepstock.jem.routing");
        MapStats routed = this.loadMapStats("org.pepstock.jem.routed");
        MapStats resources = this.loadMapStats("org.pepstock.jem.common.resources");
        MapStats roles = this.loadMapStats("org.pepstock.jem.roles");
        MapStats stats = this.loadMapStats("org.pepstock.jem.stats");
        MapStats preferences = this.loadMapStats("org.pepstock.jem.user.preferences");
        sample.getMapsStats().put(input.getName(), input);
        sample.getMapsStats().put(running.getName(), running);
        sample.getMapsStats().put(output.getName(), output);
        sample.getMapsStats().put(routing.getName(), routing);
        sample.getMapsStats().put(routed.getName(), routed);
        sample.getMapsStats().put(resources.getName(), resources);
        sample.getMapsStats().put(roles.getName(), roles);
        sample.getMapsStats().put(stats.getName(), stats);
        sample.getMapsStats().put(preferences.getName(), preferences);
    }

    private void loadHazelcastQueuesStats(MemberSample sample) {
        QueueStats jclCheck = this.loadQueueStats("org.pepstock.jem.jcl.checking");
        sample.getQueuesStats().put(jclCheck.getName(), jclCheck);
    }

    private MapStats loadMapStats(String mapName) {
        LocalMapStats stats = Main.HAZELCAST.getMap(mapName).getLocalMapStats();
        LocalMapOperationStats ostats = (LocalMapOperationStats)stats.getOperationStats();
        MapStats mstats = new MapStats();
        mstats.setName(mapName);
        mstats.setBackupEntryCount(stats.getBackupEntryCount());
        mstats.setBackupEntryMemoryCost(stats.getBackupEntryMemoryCost());
        mstats.setDirtyEntryCount(stats.getDirtyEntryCount());
        mstats.setHits(stats.getHits());
        mstats.setLockedEntryCount(stats.getLockedEntryCount());
        mstats.setLockWaitCount(stats.getLockWaitCount());
        mstats.setOwnedEntryCount(stats.getOwnedEntryCount());
        mstats.setOwnedEntryMemoryCost(stats.getOwnedEntryMemoryCost());
        MapOperationsStats mostats = mstats.getOperationsStats();
        mostats.setNumberOfEvents(ostats.getNumberOfEvents());
        mostats.setNumberOfGets(ostats.getNumberOfGets());
        mostats.setNumberOfOtherOperations(ostats.getNumberOfOtherOperations());
        mostats.setNumberOfPuts(ostats.getNumberOfPuts());
        mostats.setNumberOfRemoves(ostats.getNumberOfRemoves());
        mostats.setTotalGetLatency(ostats.getTotalGetLatency());
        mostats.setTotalPutLatency(ostats.getTotalPutLatency());
        mostats.setTotalRemoveLatency(ostats.getTotalRemoveLatency());
        return mstats;
    }

    private QueueStats loadQueueStats(String queueName) {
        LocalQueueStats stats = Main.HAZELCAST.getQueue(queueName).getLocalQueueStats();
        LocalQueueOperationStats ostats = (LocalQueueOperationStats)stats.getOperationStats();
        QueueStats qstats = new QueueStats();
        qstats.setName(queueName);
        qstats.setAveAge(stats.getAveAge());
        qstats.setBackupItemCount(stats.getBackupItemCount());
        qstats.setMaxAge(stats.getMaxAge());
        qstats.setMinAge(stats.getMinAge());
        qstats.setOwnedItemCount(stats.getOwnedItemCount());
        QueueOperationsStats qostats = qstats.getOperationsStats();
        qostats.setNumberOfEmptyPolls(ostats.getNumberOfEmptyPolls());
        qostats.setNumberOfOffers(ostats.getNumberOfOffers());
        qostats.setNumberOfPolls(ostats.getNumberOfPolls());
        qostats.setNumberOfRejectedOffers(ostats.getNumberOfRejectedOffers());
        return qstats;
    }
}

