/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.executors.stats;

import com.hazelcast.monitor.LocalMapStats;
import org.hyperic.sigar.Sigar;
import org.pepstock.jem.node.Main;
import org.pepstock.jem.node.executors.DefaultExecutor;
import org.pepstock.jem.node.stats.LightMapStats;
import org.pepstock.jem.node.stats.LightMemberSample;
import org.pepstock.jem.node.stats.LightSample;
import org.pepstock.jem.node.stats.MemberSample;

public class GetRealtimeSample
extends DefaultExecutor<LightMemberSample> {
    private static final long serialVersionUID = 1L;
    private LightSample newSample = null;

    public GetRealtimeSample(LightSample newSample) {
        this.newSample = newSample;
    }

    @Override
    public LightMemberSample call() throws Exception {
        this.checkShutDown();
        if (Main.NODE == null) {
            return null;
        }
        Sigar sigar = new Sigar();
        MemberSample member_sample = new MemberSample();
        member_sample.setMemberKey(Main.NODE.getKey());
        member_sample.setMemberLabel(Main.NODE.getLabel());
        member_sample.setMemberHostname(Main.NODE.getHostname());
        member_sample.setPid(sigar.getPid());
        return this.createLightMemberSample(this.newSample, member_sample);
    }

    private LightMemberSample createLightMemberSample(LightSample sample, MemberSample msample) {
        LightMemberSample member_sample = new LightMemberSample();
        member_sample.setMemberKey(msample.getMemberKey());
        member_sample.setMemberLabel(msample.getMemberLabel());
        member_sample.setMemberHostname(msample.getMemberHostname());
        member_sample.setPid(msample.getPid());
        member_sample.setKey(sample.getKey());
        member_sample.setTime(sample.getTime());
        member_sample.getMapsStats().put("org.pepstock.jem.input", this.createLightMapStats("org.pepstock.jem.input"));
        member_sample.getMapsStats().put("org.pepstock.jem.output", this.createLightMapStats("org.pepstock.jem.output"));
        member_sample.getMapsStats().put("org.pepstock.jem.running", this.createLightMapStats("org.pepstock.jem.running"));
        member_sample.getMapsStats().put("org.pepstock.jem.routing", this.createLightMapStats("org.pepstock.jem.routing"));
        member_sample.getInternalMapsStats().put("org.pepstock.jem.common.resources", this.createLightMapStats("org.pepstock.jem.common.resources"));
        member_sample.getInternalMapsStats().put("org.pepstock.jem.roles", this.createLightMapStats("org.pepstock.jem.roles"));
        member_sample.getInternalMapsStats().put("org.pepstock.jem.routed", this.createLightMapStats("org.pepstock.jem.routed"));
        member_sample.getInternalMapsStats().put("org.pepstock.jem.stats", this.createLightMapStats("org.pepstock.jem.stats"));
        member_sample.getInternalMapsStats().put("org.pepstock.jem.user.preferences", this.createLightMapStats("org.pepstock.jem.user.preferences"));
        return member_sample;
    }

    private LightMapStats createLightMapStats(String mapName) {
        LocalMapStats stats = Main.HAZELCAST.getMap(mapName).getLocalMapStats();
        LightMapStats lmap = new LightMapStats();
        lmap.setName(mapName);
        lmap.setOwnedEntryCount(stats.getOwnedEntryCount());
        lmap.setOwnedEntryMemoryCost(stats.getOwnedEntryMemoryCost());
        return lmap;
    }
}

