/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.executors.jobs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.pepstock.jem.Job;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.Main;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.executors.DefaultExecutor;
import org.pepstock.jem.node.executors.ExecutionResult;

public class Purge
extends DefaultExecutor<ExecutionResult> {
    private static final long serialVersionUID = 1L;
    private Job job = null;

    public Purge(Job job) {
        this.job = job;
    }

    @Override
    public ExecutionResult call() throws Exception {
        this.checkShutDown();
        File jclFile = Main.OUTPUT_SYSTEM.getJclFile(this.job);
        if (!jclFile.exists()) {
            throw new FileNotFoundException(jclFile.getAbsolutePath());
        }
        File jobOutputFolder = jclFile.getParentFile();
        try {
            FileUtils.deleteDirectory((File)jobOutputFolder);
            if (jobOutputFolder.exists()) {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC164W, this.job.toString(), jobOutputFolder.getAbsolutePath());
            }
        }
        catch (IOException ioe) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC164W, this.job.toString(), jobOutputFolder.getAbsolutePath());
        }
        return ExecutionResult.SUCCESSFUL;
    }
}

