/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.executors.jobs;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.pepstock.jem.Job;
import org.pepstock.jem.OutputListItem;
import org.pepstock.jem.OutputTree;
import org.pepstock.jem.node.Main;
import org.pepstock.jem.node.executors.DefaultExecutor;

public class GetOutputTree
extends DefaultExecutor<OutputTree> {
    private static final long serialVersionUID = 1L;
    private Job job = null;

    public GetOutputTree(Job job) {
        this.job = job;
    }

    @Override
    public OutputTree call() throws Exception {
        this.checkShutDown();
        File jclFile = Main.OUTPUT_SYSTEM.getJclFile(this.job);
        if (!jclFile.exists()) {
            throw new FileNotFoundException(jclFile.getAbsolutePath());
        }
        OutputTree tree = new OutputTree();
        File jobOutputFolder = jclFile.getParentFile();
        File[] files = jobOutputFolder.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.getName().equalsIgnoreCase("jcl.xml") || file.getName().equalsIgnoreCase("job.xml")) continue;
            if (!file.isDirectory()) {
                if (!file.getName().equalsIgnoreCase("job.log") && !file.getName().equalsIgnoreCase("messages.log")) continue;
                OutputListItem item = new OutputListItem();
                String label = file.getName().equalsIgnoreCase("job.log") ? "JEM log" : "JOB log";
                item.setLabel(label);
                String fileRelativePath = StringUtils.remove((String)file.getAbsolutePath(), (String)Main.OUTPUT_SYSTEM.getOutputPath().getAbsolutePath());
                item.setFileRelativePath(FilenameUtils.normalize((String)fileRelativePath, (boolean)true));
                tree.getFirstLevelItems().add(item);
                continue;
            }
            ArrayList<OutputListItem> secondLevelItems = new ArrayList<OutputListItem>();
            File[] stepFiles = file.listFiles();
            for (int k = 0; k < stepFiles.length; ++k) {
                File stepFile = stepFiles[k];
                if (stepFile.isDirectory()) continue;
                OutputListItem item = new OutputListItem();
                item.setLabel(stepFile.getName());
                item.setParent(file.getName());
                String fileRelativePath = StringUtils.remove((String)stepFile.getAbsolutePath(), (String)Main.OUTPUT_SYSTEM.getOutputPath().getAbsolutePath());
                item.setFileRelativePath(FilenameUtils.normalize((String)fileRelativePath, (boolean)true));
                secondLevelItems.add(item);
            }
            tree.getSecondLevelItems().put(file.getName(), secondLevelItems);
        }
        return tree;
    }
}

