/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.executors.jobs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Scanner;
import org.pepstock.jem.Job;
import org.pepstock.jem.OutputFileContent;
import org.pepstock.jem.OutputListItem;
import org.pepstock.jem.node.Main;
import org.pepstock.jem.node.executors.DefaultExecutor;

public class GetOutputFileContent
extends DefaultExecutor<OutputFileContent> {
    private static final long serialVersionUID = 1L;
    private static final int MAX_NUMBER_OF_BYTE_READABLE = 0x500000;
    private Job job = null;
    private OutputListItem item = null;

    public GetOutputFileContent(Job job, OutputListItem item) {
        this.job = job;
        this.item = item;
    }

    @Override
    public OutputFileContent call() throws Exception {
        this.checkShutDown();
        File file = new File(Main.OUTPUT_SYSTEM.getOutputPath(), this.item.getFileRelativePath());
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        StringBuffer sb = this.load(file);
        OutputFileContent output = new OutputFileContent();
        output.setContent(sb.toString());
        return output;
    }

    private StringBuffer load(File file) throws IOException {
        Scanner sc = new Scanner(file);
        sc.useDelimiter("\n");
        StringBuffer sb = new StringBuffer();
        while (sc.hasNext() && sb.length() < 0x500000) {
            sb.append(sc.next().toString()).append('\n');
        }
        sc.close();
        return sb;
    }
}

