/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.executors.jobs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Scanner;
import org.pepstock.jem.Job;
import org.pepstock.jem.OutputFileContent;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.Main;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.executors.DefaultExecutor;

public class GetMessagesLog
extends DefaultExecutor<OutputFileContent> {
    private static final long serialVersionUID = 1L;
    private static final int MAX_NUMBER_OF_BYTE_READABLE = 0x500000;
    private Job job = null;

    public GetMessagesLog(Job job) {
        this.job = job;
    }

    @Override
    public OutputFileContent call() throws Exception {
        this.checkShutDown();
        OutputFileContent output = new OutputFileContent();
        if (this.job.getRoutingInfo().getId() != null) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC197I, this.job, this.job.getJcl().getEnvironment());
            String content = NodeMessage.JEMC197I.toMessage().getFormattedMessage(this.job, this.job.getJcl().getEnvironment());
            output.setContent(content);
        } else {
            File jclFile = Main.OUTPUT_SYSTEM.getJclFile(this.job);
            if (!jclFile.exists()) {
                throw new FileNotFoundException(jclFile.getAbsolutePath());
            }
            File file = new File(jclFile.getParentFile(), "messages.log");
            if (!file.exists()) {
                throw new FileNotFoundException(file.getAbsolutePath());
            }
            StringBuffer sb = this.load(file);
            output.setContent(sb.toString());
        }
        return output;
    }

    private StringBuffer load(File file) throws IOException {
        Scanner sc = new Scanner(file);
        sc.useDelimiter("\n");
        StringBuffer sb = new StringBuffer();
        while (sc.hasNext() && sb.length() < 0x500000) {
            sb.append(sc.next().toString()).append('\n');
        }
        sc.close();
        return sb;
    }
}

