/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.executors.gfs;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.pepstock.jem.GfsFile;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.executors.DefaultExecutor;

public class GetFilesList
extends DefaultExecutor<Collection<GfsFile>> {
    private static final long serialVersionUID = 1L;
    private String path = null;
    private int type = 0;

    public GetFilesList(int type, String path) {
        this.type = type;
        this.path = path;
    }

    @Override
    public Collection<GfsFile> call() throws Exception {
        this.checkShutDown();
        String parentPath = null;
        File parent = null;
        switch (this.type) {
            case 0: {
                parentPath = System.getProperty("jem.data");
                break;
            }
            case 1: {
                parentPath = System.getProperty("jem.library");
                break;
            }
            case 2: {
                parentPath = System.getProperty("jem.source");
                break;
            }
            case 3: {
                parentPath = System.getProperty("jem.classpath");
                break;
            }
            case 4: {
                parentPath = System.getProperty("jem.binary");
                break;
            }
            default: {
                parentPath = System.getProperty("jem.data");
            }
        }
        parent = new File(parentPath, this.path);
        if (!parent.exists()) {
            throw new Exception(NodeMessage.JEMC186E.toMessage().getFormattedMessage(this.path));
        }
        if (!parent.isDirectory()) {
            throw new Exception(NodeMessage.JEMC187E.toMessage().getFormattedMessage(this.path));
        }
        ArrayList<GfsFile> list = new ArrayList<GfsFile>();
        File[] files = parent.listFiles();
        if (files != null && files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                boolean isDirectory = files[i].isDirectory();
                String name = files[i].getName();
                String longName = StringUtils.removeStart((String)FilenameUtils.normalize((String)files[i].getAbsolutePath(), (boolean)true), (String)parentPath).substring(1);
                GfsFile file = new GfsFile();
                file.setDirectory(isDirectory);
                file.setName(name);
                file.setLongName(longName);
                file.setLength(isDirectory ? -1L : files[i].length());
                file.setLastModified(files[i].lastModified());
                list.add(file);
            }
        }
        return list;
    }
}

