/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.executors.gfs;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.executors.DefaultExecutor;

public class GetFile
extends DefaultExecutor<String> {
    private static final long serialVersionUID = 1L;
    private String file = null;
    private int type = 0;

    public GetFile(int type, String file) {
        this.type = type;
        this.file = file;
    }

    @Override
    public String call() throws Exception {
        this.checkShutDown();
        String parentPath = null;
        File fileToRead = null;
        switch (this.type) {
            case 0: {
                parentPath = System.getProperty("jem.data");
                break;
            }
            case 1: {
                parentPath = System.getProperty("jem.library");
                break;
            }
            case 2: {
                parentPath = System.getProperty("jem.source");
                break;
            }
            case 3: {
                parentPath = System.getProperty("jem.classpath");
                break;
            }
            case 4: {
                parentPath = System.getProperty("jem.binary");
                break;
            }
            default: {
                parentPath = System.getProperty("jem.data");
            }
        }
        fileToRead = new File(parentPath, this.file);
        if (!fileToRead.exists()) {
            throw new Exception(NodeMessage.JEMC186E.toMessage().getFormattedMessage(this.file));
        }
        if (!fileToRead.isFile()) {
            throw new Exception(NodeMessage.JEMC188E.toMessage().getFormattedMessage(this.file));
        }
        String content = FileUtils.readFileToString((File)fileToRead);
        return content;
    }
}

