/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.executors.configuration;

import com.hazelcast.core.ILock;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.pepstock.jem.node.ConfigurationFile;
import org.pepstock.jem.node.Main;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.executors.DefaultExecutor;

public abstract class SaveXmlConfigurationFile
extends DefaultExecutor<ConfigurationFile> {
    private static final long serialVersionUID = 1L;
    private ConfigurationFile configFile = null;

    public SaveXmlConfigurationFile(ConfigurationFile configFile) {
        this.configFile = configFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ConfigurationFile call() throws Exception {
        this.checkShutDown();
        String property = this.getSystemProperty();
        ILock writeSynch = null;
        writeSynch = Main.HAZELCAST.getLock((Object)property);
        writeSynch.lock();
        try {
            String jemNodeConfigFile = System.getProperty(property);
            File file = new File(jemNodeConfigFile);
            if (file.lastModified() != this.configFile.getLastModified()) {
                throw new Exception(NodeMessage.JEMC208E.toMessage().getFormattedMessage(this.configFile.getLastModified(), file.lastModified()));
            }
            FileUtils.writeStringToFile((File)file, (String)this.configFile.getContent());
            file = new File(jemNodeConfigFile);
            ConfigurationFile newConfigFile = new ConfigurationFile();
            newConfigFile.setContent(this.configFile.getContent());
            newConfigFile.setType("xml");
            newConfigFile.setLastModified(file.lastModified());
            ConfigurationFile configurationFile = newConfigFile;
            return configurationFile;
        }
        finally {
            writeSynch.unlock();
        }
    }

    public abstract String getSystemProperty();
}

