/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.executors;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.About;
import org.pepstock.jem.node.Main;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.executors.DefaultExecutor;

public class GetAbout
extends DefaultExecutor<About> {
    private static final long serialVersionUID = 1L;

    @Override
    public About call() throws Exception {
        this.checkShutDown();
        About about = new About();
        try {
            Class<?> clazz = Class.forName("org.pepstock.jem.license.GetLicensesInfo");
            Callable da = (Callable)clazz.newInstance();
            about.getLicenses().addAll((Collection)da.call());
        }
        catch (ClassNotFoundException e) {
        }
        catch (Exception e) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC207E, e);
        }
        this.loadManifest(about);
        return about;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadManifest(About about) {
        ZipFile jarFile = null;
        try {
            String creation;
            jarFile = new JarFile(new File(Main.class.getProtectionDomain().getCodeSource().getLocation().toURI()));
            Attributes at = ((JarFile)jarFile).getManifest().getAttributes("JEM_the_BEE");
            String version = at.getValue("Jem_version");
            if (version != null) {
                about.setVersion(version);
            }
            if ((creation = at.getValue("Creation_time")) != null) {
                about.setCreationTime(creation);
            }
        }
        catch (IOException e) {
            LogAppl.getInstance().emit(NodeMessage.JEMC184W);
        }
        catch (URISyntaxException e) {
            LogAppl.getInstance().emit(NodeMessage.JEMC184W);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

