/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.events;

import java.util.EventListener;
import java.util.concurrent.LinkedBlockingQueue;
import org.pepstock.jem.Job;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.events.JobLifecycleEvent;
import org.pepstock.jem.node.events.JobLifecycleListener;
import org.pepstock.jem.node.events.ListenersSystem;

public class JobLifecycleListenersSystem
extends ListenersSystem {
    private LinkedBlockingQueue<JobLifecycleEvent> queue = new LinkedBlockingQueue();

    public JobLifecycleListenersSystem() {
        Notifier notifier = new Notifier();
        notifier.start();
    }

    public boolean hasListeners() {
        return this.hasListener(JobLifecycleListener.class);
    }

    public synchronized void addJobLifecycleEvent(JobLifecycleEvent event) {
        try {
            this.queue.put(event);
        }
        catch (InterruptedException e) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC042E, e);
        }
    }

    class Notifier
    extends Thread {
        Notifier() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        JobLifecycleEvent event;
                        if ((event = (JobLifecycleEvent)JobLifecycleListenersSystem.this.queue.take()).getStatus().equalsIgnoreCase("org.pepstock.jem.input")) {
                            this.fireQueued(event.getJob());
                            continue;
                        }
                        if (event.getStatus().equalsIgnoreCase("org.pepstock.jem.running")) {
                            this.fireRunning(event.getJob());
                            continue;
                        }
                        if (!event.getStatus().equalsIgnoreCase("org.pepstock.jem.output")) continue;
                        this.fireEnded(event.getJob());
                    }
                }
                catch (Exception e) {
                    LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC041E, e);
                    continue;
                }
                break;
            }
        }

        public void fireQueued(Job job) {
            EventListener[] listener = JobLifecycleListenersSystem.this.getAllListeners(JobLifecycleListener.class);
            for (int i = 0; i < listener.length; ++i) {
                ((JobLifecycleListener)listener[i]).queued(job);
            }
        }

        public void fireRunning(Job job) {
            EventListener[] listener = JobLifecycleListenersSystem.this.getAllListeners(JobLifecycleListener.class);
            for (int i = 0; i < listener.length; ++i) {
                ((JobLifecycleListener)listener[i]).running(job);
            }
        }

        public void fireEnded(Job job) {
            EventListener[] listener = JobLifecycleListenersSystem.this.getAllListeners(JobLifecycleListener.class);
            for (int i = 0; i < listener.length; ++i) {
                ((JobLifecycleListener)listener[i]).ended(job);
            }
        }
    }
}

