/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.events;

import java.util.Properties;
import org.pepstock.jem.Job;
import org.pepstock.jem.NodeInfoBean;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.Main;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.events.JobLifecycleListener;
import org.pepstock.jem.notify.JemEmail;
import org.pepstock.jem.notify.NotifyMessage;
import org.pepstock.jem.notify.engine.EmailNotifier;
import org.pepstock.jem.notify.engine.EmailTemplateReader;
import org.pepstock.jem.notify.engine.Factory;
import org.pepstock.jem.notify.exception.NotifyException;
import org.pepstock.jem.util.Parser;
import org.pepstock.jem.util.VariablesFactory;

public class EmailEndJobListener
extends EmailNotifier
implements JobLifecycleListener {
    private static final String EMAIL_ADDRESSES_SEPARATOR = ";";
    private static final String EMAIL_SERVER_PROPERTY = "jem.emailServer";
    private static final String BOUNCE_ADDRESS_PROPERTY = "jem.bounceAddress";
    private static final String EMAIL_TEMPLATE_FILE_PROPERTY = "jem.emailTemplateFile";
    private static final String SMTP_PORT_PROPERTY = "jem.smtpPort";
    private static final String IS_SSL_PROTOCOL_PROPERTY = "jem.isSSLProtocol";
    private static final String IS_TLS_PROTOCOL_PROPERTY = "jem.isTLSProtocol";
    private static final String SMTP_AUTHENTICATION_USERID_PROPERTY = "jem.smtp.authentication.userid";
    private static final String SMTP_AUTHENTICATION_PASSWORD_PROPERTY = "jem.smtp.authentication.password";
    private EmailTemplateReader emailTemplateReader = null;

    @Override
    public void init(Properties properties) {
        try {
            String emailServer = properties.getProperty(EMAIL_SERVER_PROPERTY);
            String bounceAddress = properties.getProperty(BOUNCE_ADDRESS_PROPERTY);
            String emailTemplateFileStr = properties.getProperty(EMAIL_TEMPLATE_FILE_PROPERTY);
            String authenticationUserId = properties.getProperty(SMTP_AUTHENTICATION_USERID_PROPERTY);
            String authenticationPassword = properties.getProperty(SMTP_AUTHENTICATION_PASSWORD_PROPERTY);
            boolean isSSL = false;
            boolean isTLS = false;
            int smtpPort = -1;
            if (null != properties.getProperty(IS_SSL_PROTOCOL_PROPERTY)) {
                String isSslStr = properties.getProperty(IS_SSL_PROTOCOL_PROPERTY);
                isSSL = Parser.parseBoolean(isSslStr, false);
            }
            if (null != properties.getProperty(IS_TLS_PROTOCOL_PROPERTY)) {
                String isTlsStr = properties.getProperty(IS_TLS_PROTOCOL_PROPERTY);
                isTLS = Parser.parseBoolean(isTlsStr, false);
            }
            if (null != properties.getProperty(SMTP_PORT_PROPERTY)) {
                String smtpPortStr = properties.getProperty(SMTP_PORT_PROPERTY);
                smtpPort = Parser.parseInt(smtpPortStr, -1);
            }
            if (null == emailTemplateFileStr) {
                LogAppl.getInstance().emit((MessageInterface)NotifyMessage.JEMN012E, EMAIL_TEMPLATE_FILE_PROPERTY);
            } else {
                super.init(emailServer, bounceAddress, isSSL, isTLS, smtpPort, authenticationUserId, authenticationPassword);
                LogAppl.getInstance().emit((MessageInterface)NotifyMessage.JEMN017I, this.toString());
                this.emailTemplateReader = new EmailTemplateReader(emailTemplateFileStr);
                this.emailTemplateReader.initialize();
            }
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC037I, this.getClass().getName());
        }
        catch (NotifyException nEx) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC035E, nEx, this.getClass().getName());
        }
    }

    @Override
    public void ended(Job job) {
        if (job.getJcl().hasEmailNotificationAddresses()) {
            try {
                NodeInfoBean nodeInfo = Main.NODE.getNodeInfoBean();
                Properties variables = VariablesFactory.createVariables(job, nodeInfo);
                String emailAddressesStr = job.getJcl().getEmailNotificationAddresses();
                String[] emailAddresses = emailAddressesStr.split(EMAIL_ADDRESSES_SEPARATOR);
                JemEmail email = Factory.createEmail(this.emailTemplateReader.getEmailTemplate(), emailAddresses, variables);
                super.doNotify(email);
            }
            catch (Exception ex) {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC074E, ex);
            }
        } else {
            LogAppl.getInstance().emit(NotifyMessage.JEMN018W);
        }
    }

    @Override
    public void queued(Job job) {
    }

    @Override
    public void running(Job job) {
    }
}

