/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.affinity;

import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.hyperic.sigar.Mem;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;
import org.pepstock.jem.node.system.Ps;

public final class SystemInfo {
    private static final Sigar sigar = new Sigar();
    private Properties runtime = null;
    private Properties environment = null;
    private Properties network = null;

    public Properties getSystemProperties() {
        return System.getProperties();
    }

    public Properties getRuntimeProperties() {
        if (this.runtime == null) {
            this.runtime = new Properties();
            String s = null;
            try {
                s = String.valueOf(Runtime.getRuntime().availableProcessors());
                this.runtime.setProperty("availableProcessors", s);
                Mem memory = sigar.getMem();
                s = String.valueOf(memory.getFree());
                this.runtime.setProperty("freeMemory", s);
                s = String.valueOf(memory.getTotal());
                this.runtime.setProperty("totalMemory", s);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.runtime;
    }

    public Properties getEnvironment() {
        if (this.environment == null) {
            this.environment = new Properties();
            Map<String, String> props = System.getenv();
            for (Map.Entry<String, String> entry : props.entrySet()) {
                this.environment.setProperty(entry.getKey(), entry.getValue());
            }
        }
        return this.environment;
    }

    public Properties getNetworkProperties() {
        if (this.network == null) {
            this.network = new Properties();
            try {
                ArrayList<InetAddress> list = new ArrayList<InetAddress>();
                try {
                    Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                    while (interfaces.hasMoreElements()) {
                        NetworkInterface ni = interfaces.nextElement();
                        Enumeration<InetAddress> addresses = ni.getInetAddresses();
                        while (addresses.hasMoreElements()) {
                            InetAddress addr = addresses.nextElement();
                            list.add(addr);
                        }
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                String hostname = StringUtils.substringAfter((String)ManagementFactory.getRuntimeMXBean().getName(), (String)"@");
                this.network.setProperty("ipaddresses", SystemInfo.formatAddresses(list));
                this.network.setProperty("hostnames", hostname);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.network;
    }

    public static ArrayList<String> getRunningProcesses() {
        ArrayList<String> processes = new ArrayList<String>();
        try {
            long[] pids = sigar.getProcList();
            for (int i = 0; i < pids.length; ++i) {
                List<String> info;
                long pid = pids[i];
                try {
                    info = Ps.getInfo((SigarProxy)sigar, pid);
                }
                catch (SigarException e) {
                    continue;
                }
                processes.add(Ps.join(info));
            }
        }
        catch (SigarException sigarException) {
            // empty catch block
        }
        return processes;
    }

    private static String formatAddresses(List<? extends InetAddress> addresses) {
        StringBuilder sb = new StringBuilder();
        for (InetAddress inetAddress : addresses) {
            String ip = inetAddress.getHostAddress();
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(ip);
        }
        return sb.toString();
    }
}

