/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.affinity;

import java.io.File;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.pepstock.jem.Job;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.Main;
import org.pepstock.jem.node.NodeInfoUtility;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.Status;
import org.pepstock.jem.node.affinity.Result;
import org.pepstock.jem.node.affinity.ScriptAffinityLoader;
import org.pepstock.jem.node.affinity.SystemInfo;
import org.pepstock.jem.node.events.JobLifecycleListener;

public abstract class PolicyAffinityLoader
extends FileAlterationListenerAdaptor
implements ScriptAffinityLoader,
JobLifecycleListener {
    private static final String POLICY_FILENAME_KEY = "jem.affinity.loader.policy";
    private File scriptFile = null;
    private Result currentResult = null;
    private boolean reloadAfterJobEnded = false;
    private static final long pollingInterval = 5000L;

    @Override
    public final void init(Properties properties) {
        String fileName = properties.getProperty(POLICY_FILENAME_KEY);
        if (fileName != null) {
            this.scriptFile = new File(fileName);
            if (this.scriptFile.exists()) {
                Main.JOB_LIFECYCLE_LISTENERS_SYSTEM.addListener(JobLifecycleListener.class, this);
                FileAlterationObserver observer = new FileAlterationObserver(this.scriptFile.getParent());
                FileAlterationMonitor monitor = new FileAlterationMonitor(5000L);
                observer.addListener((FileAlterationListener)this);
                monitor.addObserver(observer);
                try {
                    monitor.start();
                }
                catch (Exception e) {
                    // empty catch block
                }
                String className = FilenameUtils.getExtension((String)this.getClass().getName());
                Timer timer = new Timer(className, false);
                timer.schedule((TimerTask)new PeriodicallyAffinitiesReloader(), 300000L, 300000L);
            }
        }
    }

    @Override
    public final Result load(SystemInfo info) throws Exception {
        if (this.scriptFile == null) {
            throw new Exception(NodeMessage.JEMC114E.toMessage().getFormattedMessage(POLICY_FILENAME_KEY));
        }
        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC051I, this.scriptFile.getAbsolutePath());
        Result result = this.runScript(this.scriptFile, info);
        if (this.currentResult == null) {
            this.currentResult = result;
        }
        return result;
    }

    @Override
    public File getScriptFile() {
        return this.scriptFile;
    }

    public void onFileChange(File file) {
        if (file.getAbsolutePath().equalsIgnoreCase(this.scriptFile.getAbsolutePath())) {
            try {
                Result newResult = this.load(new SystemInfo());
                if (newResult != null && !newResult.getAffinities().isEmpty()) {
                    Main.EXECUTION_ENVIRONMENT.getDynamicAffinities().clear();
                    this.currentResult = newResult;
                    Main.EXECUTION_ENVIRONMENT.getDynamicAffinities().addAll(this.currentResult.getAffinities());
                    Main.EXECUTION_ENVIRONMENT.setMemory(this.currentResult.getMemory());
                    NodeInfoUtility.storeNodeInfo(Main.NODE);
                }
            }
            catch (Exception e) {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC031E, e, this.getClass().getName());
            }
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC050I, Main.EXECUTION_ENVIRONMENT);
        }
    }

    @Override
    public void queued(Job job) {
    }

    @Override
    public void running(Job job) {
    }

    @Override
    public void ended(Job job) {
        if (this.reloadAfterJobEnded) {
            this.reloadAfterJobEnded = false;
            this.onFileChange(this.scriptFile);
        }
    }

    class PeriodicallyAffinitiesReloader
    extends TimerTask {
        PeriodicallyAffinitiesReloader() {
        }

        @Override
        public void run() {
            if (!Main.IS_SHUTTING_DOWN) {
                if (Main.NODE.getStatus().equals(Status.DRAINED) || Main.NODE.getStatus().equals(Status.INACTIVE)) {
                    PolicyAffinityLoader.this.onFileChange(PolicyAffinityLoader.this.scriptFile);
                } else {
                    PolicyAffinityLoader.this.reloadAfterJobEnded = true;
                }
            }
        }
    }
}

