/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node.affinity;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.affinity.PolicyAffinityLoader;
import org.pepstock.jem.node.affinity.Result;
import org.pepstock.jem.node.affinity.SystemInfo;
import org.pepstock.jem.util.Parser;

public class JSPolicyAffinityLoader
extends PolicyAffinityLoader {
    public static final String TYPE = "javascript";
    private static final String JS_RESULT_VARIABLE = "RESULT";
    private static final String JS_MEMORY_VARIABLE = "MEMORY";
    private static final String JS_SYSINFO_VARIABLE = "SYSINFO";

    @Override
    public Result runScript(File script, SystemInfo info) throws Exception {
        return this.runScript(new FileReader(script), info);
    }

    @Override
    public String getScriptType() {
        return TYPE;
    }

    @Override
    public Result testScript(String script, SystemInfo info) throws Exception {
        return this.runScript(new StringReader(script), info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result runScript(Reader reader, SystemInfo info) throws Exception {
        Result result = new Result();
        Context jsContext = Context.enter();
        try {
            ScriptableObject scope = jsContext.initStandardObjects();
            String s = "";
            jsContext.newObject((Scriptable)scope);
            scope.defineProperty(JS_SYSINFO_VARIABLE, (Object)info, 1);
            jsContext.evaluateReader((Scriptable)scope, reader, s, 1, null);
            Object x = scope.get(JS_RESULT_VARIABLE, (Scriptable)scope);
            if (x == Scriptable.NOT_FOUND) {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC092E, JS_RESULT_VARIABLE);
            } else {
                String affinities = Context.toString((Object)x);
                if (affinities != null && affinities.trim().length() > 0) {
                    String[] affinitiesValues = affinities.split(",");
                    for (int i = 0; i < affinitiesValues.length; ++i) {
                        result.getAffinities().add(affinitiesValues[i].trim().toLowerCase());
                    }
                }
            }
            Object xm = scope.get(JS_MEMORY_VARIABLE, (Scriptable)scope);
            if (xm == Scriptable.NOT_FOUND) {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC092E, JS_MEMORY_VARIABLE);
            } else {
                String memoryString = Context.toString((Object)xm);
                int memory = Parser.parseInt(memoryString, 128);
                result.setMemory(memory);
            }
        }
        finally {
            Context.exit();
        }
        return result;
    }
}

