/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node;

import com.hazelcast.core.IMap;
import com.hazelcast.core.ITopic;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.pepstock.jem.Job;
import org.pepstock.jem.Result;
import org.pepstock.jem.factories.JemFactory;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.CancelableTask;
import org.pepstock.jem.node.JobLogManager;
import org.pepstock.jem.node.Main;
import org.pepstock.jem.node.NodeInfoUtility;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.ShutDownInterface;
import org.pepstock.jem.node.ShutDownJob;
import org.pepstock.jem.node.Status;
import org.pepstock.jem.node.events.JobLifecycleEvent;
import org.pepstock.jem.node.rmi.CommonResourcerImpl;
import org.pepstock.jem.node.rmi.ExternalObject;
import org.pepstock.jem.node.rmi.ResourceLockerImpl;
import org.pepstock.jem.node.rmi.TasksDoorImpl;
import org.pepstock.jem.node.tasks.JobTask;
import org.pepstock.jem.util.rmi.RegistryContainer;

public class Submitter
extends Thread
implements ShutDownInterface {
    private static final String CLASS_FOR_EXTERNAL = "org.pepstock.jem.ant.AntUtilManager";
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private boolean isDown = false;

    @Override
    public void run() {
        try {
            RegistryContainer.getInstance().addRmiObject("TASKS_DOOR", new TasksDoorImpl());
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC015I, "TASKS_DOOR");
            RegistryContainer.getInstance().addRmiObject("RESOURCE_LOCKER", new ResourceLockerImpl());
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC015I, "RESOURCE_LOCKER");
            RegistryContainer.getInstance().addRmiObject("COMMON_RESOURCE", new CommonResourcerImpl());
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC015I, "COMMON_RESOURCE");
            try {
                Class<?> internals = Class.forName(CLASS_FOR_EXTERNAL);
                ExternalObject externalObject = (ExternalObject)internals.newInstance();
                RegistryContainer.getInstance().addRmiObject(externalObject.getName(), externalObject.getObject());
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC195I, externalObject.getName());
            }
            catch (ClassNotFoundException e) {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC196W, CLASS_FOR_EXTERNAL);
            }
            catch (InstantiationException e) {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC196W, CLASS_FOR_EXTERNAL);
            }
            catch (IllegalAccessException e) {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC196W, CLASS_FOR_EXTERNAL);
            }
            catch (RemoteException e) {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC196W, CLASS_FOR_EXTERNAL);
            }
        }
        catch (RemoteException e) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC016E, e, "TASKS_DOOR");
            return;
        }
        while (!this.isDown) {
            try {
                Main.INPUT_QUEUE_MANAGER.checkJobToSubmit();
                Job job = Main.INPUT_QUEUE_MANAGER.takeJob();
                if (job == null) continue;
                if (job instanceof ShutDownJob) {
                    this.isDown = true;
                    continue;
                }
                this.submit(job);
            }
            catch (InterruptedException e) {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC068W, StringUtils.substringAfterLast((String)Submitter.class.getName(), (String)"."));
            }
        }
        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC069I, StringUtils.substringAfterLast((String)Submitter.class.getName(), (String)"."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void submit(Job job) {
        if (job == null) {
            return;
        }
        ++Main.NUMBER_OF_JOB_SUBMITTED;
        Main.NODE.setJob(job);
        Main.NODE.getRequest().setRequestorName(job.getName());
        Main.NODE.getRequest().setRequestorId(job.getId());
        NodeInfoUtility.storeNodeInfo(Main.NODE);
        JemFactory factory = Main.FACTORIES_LIST.get(job.getJcl().getType());
        JobTask at = factory.createJobTask(job);
        Main.CURRENT_TASK = new CancelableTask(at);
        Main.JOB_LIFECYCLE_LISTENERS_SYSTEM.addJobLifecycleEvent(new JobLifecycleEvent("org.pepstock.jem.running", job));
        this.executor.submit(Main.CURRENT_TASK);
        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC020I, job.toString());
        Result result = null;
        StringWriter sw = new StringWriter();
        try {
            result = (Result)Main.CURRENT_TASK.get();
            if (result.getReturnCode() != 222) {
                job.setResult(result);
                job.setEndedTime(new Date());
                this.jobEnded(job);
            }
        }
        catch (CancellationException e) {
            e.printStackTrace(new PrintWriter(sw));
            result = new Result();
            result.setReturnCode(222);
            result.setExceptionMessage(sw.getBuffer().toString());
            job.setResult(result);
            job.setEndedTime(new Date());
            this.jobEnded(job);
        }
        catch (InterruptedException e) {
            e.printStackTrace(new PrintWriter(sw));
            result = new Result();
            result.setReturnCode(1);
            result.setExceptionMessage(sw.getBuffer().toString());
            job.setResult(result);
            job.setEndedTime(new Date());
            this.jobEnded(job);
        }
        catch (ExecutionException e) {
            e.printStackTrace(new PrintWriter(sw));
            result = new Result();
            result.setReturnCode(16);
            result.setExceptionMessage(sw.getBuffer().toString());
            job.setResult(result);
            job.setEndedTime(new Date());
            this.jobEnded(job);
        }
        catch (Exception e) {
            e.printStackTrace(new PrintWriter(sw));
            result = new Result();
            result.setReturnCode(16);
            result.setExceptionMessage(sw.getBuffer().toString());
            job.setResult(result);
            job.setEndedTime(new Date());
            this.jobEnded(job);
        }
        if (!Main.NODE.getRequest().getResources().isEmpty()) {
            Main.NODE.getRequest().unlock();
            Main.NODE.getRequest().getResources().clear();
        }
        JobLogManager.printFooter(job, result.getReturnCode(), result.getExceptionMessage());
        Main.OUTPUT_SYSTEM.writeJob(job);
        Main.CURRENT_TASK = null;
        Main.NODE.getLock().lock();
        try {
            if (Main.NODE.getStatus().equals(Status.DRAINING)) {
                Main.NODE.setStatus(Status.DRAINED);
            } else {
                Main.NODE.setStatus(Status.INACTIVE);
            }
            Main.NODE.setJob(null);
            Main.NODE.getRequest().setRequestorName(Main.NODE.getKey());
            Main.NODE.getRequest().setRequestorName(Main.NODE.getLabel());
            NodeInfoUtility.storeNodeInfo(Main.NODE);
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC030I, Main.NODE.getStatus());
        }
        finally {
            Main.NODE.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jobEnded(Job job) {
        job.setRunningStatus(0);
        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC021I, job.toString(), String.valueOf(job.getResult().getReturnCode()));
        IMap runningQueue = Main.HAZELCAST.getMap("org.pepstock.jem.running");
        IMap outputQueue = Main.HAZELCAST.getMap("org.pepstock.jem.output");
        try {
            runningQueue.lock((Object)job.getId());
            outputQueue.lock((Object)job.getId());
            runningQueue.remove((Object)job.getId());
            outputQueue.put((Object)job.getId(), (Object)job);
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC175E, ex, job.getName());
        }
        finally {
            runningQueue.unlock((Object)job.getId());
            outputQueue.unlock((Object)job.getId());
        }
        Main.JOB_LIFECYCLE_LISTENERS_SYSTEM.addJobLifecycleEvent(new JobLifecycleEvent("org.pepstock.jem.output", job));
        ITopic topic = Main.HAZELCAST.getTopic("org.pepstock.jem.job.ended");
        topic.publish((Object)job);
    }

    @Override
    public void shutdown() throws Exception {
        while (!this.isDown) {
            Thread.sleep(1000L);
        }
    }
}

