/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node;

import com.hazelcast.core.Cluster;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Member;
import com.hazelcast.core.MultiTask;
import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.Main;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.executors.stats.GetSample;
import org.pepstock.jem.node.stats.LightMemberSample;
import org.pepstock.jem.node.stats.LightSample;
import org.pepstock.jem.node.stats.MemberSample;
import org.pepstock.jem.node.stats.Sample;
import org.pepstock.jem.node.stats.TimeComparator;
import org.pepstock.jem.util.DateFormatter;

public class StatisticsManager {
    private static final int MAXIMUM_NUMBER_OF_SAMPLES = 20;
    private static final long pollingInterval = 60000L;
    public static final String STATS = "stats";
    private String savedDay = DateFormatter.getCurrentDate("yyyyMMdd");
    private Timer timer = null;
    private TimeComparator comparator = null;
    private File folderStatsLog = null;
    private File statsLog = null;
    private XStream xs = new XStream();
    private MemberSample lastMemberSample = null;
    private boolean enable = true;

    public StatisticsManager() {
        this(true);
    }

    public StatisticsManager(boolean enable) {
        this(enable, null);
    }

    public StatisticsManager(boolean enable, String path) {
        this.enable = enable;
        if (enable) {
            File dataPath = path == null ? Main.OUTPUT_SYSTEM.getDataPath() : new File(path);
            this.folderStatsLog = new File(dataPath, STATS);
            if (!this.folderStatsLog.exists()) {
                boolean isCreated = this.folderStatsLog.mkdirs();
                if (isCreated) {
                    LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC075I, FilenameUtils.normalize((String)this.folderStatsLog.getAbsolutePath()));
                } else {
                    LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC153E, FilenameUtils.normalize((String)this.folderStatsLog.getAbsolutePath()));
                    this.enable = false;
                }
            } else {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC076I, FilenameUtils.normalize((String)this.folderStatsLog.getAbsolutePath()));
            }
        } else {
            LogAppl.getInstance().emit(NodeMessage.JEMC183W);
        }
    }

    public void init() {
        if (this.enable) {
            this.statsLog = new File(this.folderStatsLog, Main.NODE.getKey() + "." + this.savedDay);
        }
        this.comparator = new TimeComparator();
        String className = FilenameUtils.getExtension((String)this.getClass().getName());
        this.timer = new Timer(className, false);
        this.timer.schedule((TimerTask)new StatsTimerTask(), 60000L, 60000L);
        this.xs.omitField(LightMemberSample.class, "sample");
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        LogAppl.getInstance().emit(NodeMessage.JEMC077I);
    }

    public MemberSample getLastMemberSample() {
        return this.lastMemberSample;
    }

    public void setLastMemberSample(MemberSample lastMemberSample) {
        this.lastMemberSample = lastMemberSample;
    }

    public void write(Sample sample) {
        if (this.enable) {
            try {
                String currentDay = DateFormatter.getCurrentDate("yyyyMMdd");
                if (!this.savedDay.equalsIgnoreCase(currentDay)) {
                    this.savedDay = currentDay;
                    this.statsLog = new File(this.folderStatsLog, Main.NODE.getKey() + "." + this.savedDay);
                    LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC082I, this.statsLog.getAbsolutePath());
                }
                String ee = this.xs.toXML((Object)sample);
                ee = StringUtils.remove((String)ee, (char)'\n');
                ee = StringUtils.remove((String)ee, (char)' ');
                PrintStream ps = new PrintStream(new FileOutputStream(this.statsLog, true));
                ps.println(ee);
                ps.close();
            }
            catch (Exception e) {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC080E, e, this.statsLog.getAbsolutePath());
            }
        }
    }

    class StatsTimerTask
    extends TimerTask {
        private boolean isExecuting = false;
        private boolean manager = Main.IS_COORDINATOR;

        public StatsTimerTask() {
            if (StatisticsManager.this.enable) {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC082I, StatisticsManager.this.statsLog.getAbsolutePath());
            }
            if (this.manager) {
                LogAppl.getInstance().emit(NodeMessage.JEMC078I);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long elapsed;
            if (Main.IS_SHUTTING_DOWN) {
                return;
            }
            if (Main.IS_ACCESS_MAINT) {
                LogAppl.getInstance().emit(NodeMessage.JEMC189I);
                return;
            }
            if (this.isExecuting) {
                LogAppl.getInstance().emit(NodeMessage.JEMC161W);
                return;
            }
            long start = System.currentTimeMillis();
            if (Main.IS_COORDINATOR) {
                if (!this.manager) {
                    LogAppl.getInstance().emit(NodeMessage.JEMC078I);
                    this.manager = Main.IS_COORDINATOR;
                }
                Cluster cluster = Main.HAZELCAST.getCluster();
                HashSet<Member> listOfNodes = new HashSet<Member>();
                for (Member member : cluster.getMembers()) {
                    if (member.isLiteMember()) continue;
                    listOfNodes.add(member);
                }
                if (!listOfNodes.isEmpty()) {
                    block16: {
                        String key = DateFormatter.getCurrentDate("yyyy-MM-dd HH:mm");
                        String[] times = StringUtils.split((String)key, (char)' ');
                        Sample environmentSample = new Sample();
                        environmentSample.setKey(key);
                        environmentSample.setDate(times[0]);
                        environmentSample.setTime(times[1]);
                        environmentSample.setEnvironment(Main.EXECUTION_ENVIRONMENT.getEnvironment());
                        LightSample lightEnvironmentSample = new LightSample();
                        lightEnvironmentSample.setKey(key);
                        lightEnvironmentSample.setDate(times[0]);
                        lightEnvironmentSample.setTime(times[1]);
                        MultiTask task = new MultiTask((Callable)new GetSample(environmentSample), listOfNodes);
                        ExecutorService executorService = Main.HAZELCAST.getExecutorService();
                        executorService.execute((Runnable)task);
                        try {
                            this.isExecuting = true;
                            Collection results = task.get();
                            for (LightMemberSample result : results) {
                                if (result == null) continue;
                                lightEnvironmentSample.getMembers().add(result);
                            }
                            if (lightEnvironmentSample.getMembers().isEmpty()) break block16;
                            IMap samples = Main.HAZELCAST.getMap("org.pepstock.jem.stats");
                            try {
                                samples.lockMap(10L, TimeUnit.SECONDS);
                                samples.put((Object)lightEnvironmentSample.getKey(), (Object)lightEnvironmentSample);
                                int size = samples.size();
                                if (size > 20) {
                                    String oldestKey = Collections.min(samples.keySet(), StatisticsManager.this.comparator);
                                    samples.remove((Object)oldestKey);
                                }
                            }
                            finally {
                                samples.unlockMap();
                            }
                        }
                        catch (ExecutionException e) {
                            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC079E, e);
                        }
                        catch (InterruptedException e) {
                            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC079E, e);
                        }
                    }
                    this.isExecuting = false;
                }
            }
            if ((elapsed = System.currentTimeMillis() - start) > 2000L) {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC081W, String.valueOf(elapsed));
            }
        }
    }
}

