/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node;

import com.hazelcast.config.Config;
import com.hazelcast.config.FileSystemXmlConfig;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.core.ISemaphore;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipListener;
import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Key;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FilenameUtils;
import org.pepstock.jem.Job;
import org.pepstock.jem.Result;
import org.pepstock.jem.factories.JemFactory;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.Main;
import org.pepstock.jem.node.NodeInfo;
import org.pepstock.jem.node.NodeInfoUtility;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.OutputSystem;
import org.pepstock.jem.node.StatisticsManager;
import org.pepstock.jem.node.Status;
import org.pepstock.jem.node.affinity.AffinityLoader;
import org.pepstock.jem.node.affinity.SystemInfo;
import org.pepstock.jem.node.configuration.AffinityFactory;
import org.pepstock.jem.node.configuration.Configuration;
import org.pepstock.jem.node.configuration.ConfigurationException;
import org.pepstock.jem.node.configuration.CustomResourceDefinition;
import org.pepstock.jem.node.configuration.Database;
import org.pepstock.jem.node.configuration.Factory;
import org.pepstock.jem.node.configuration.Listener;
import org.pepstock.jem.node.configuration.Node;
import org.pepstock.jem.node.configuration.Paths;
import org.pepstock.jem.node.configuration.StatsManager;
import org.pepstock.jem.node.configuration.SwarmConfiguration;
import org.pepstock.jem.node.events.JobLifecycleListener;
import org.pepstock.jem.node.listeners.NodeListener;
import org.pepstock.jem.node.persistence.CommonResourcesDBManager;
import org.pepstock.jem.node.persistence.DBPoolManager;
import org.pepstock.jem.node.persistence.JobDBManager;
import org.pepstock.jem.node.persistence.PreJobDBManager;
import org.pepstock.jem.node.persistence.RecoveryManager;
import org.pepstock.jem.node.persistence.RolesDBManager;
import org.pepstock.jem.node.persistence.RoutingConfigDBManager;
import org.pepstock.jem.node.persistence.SQLContainer;
import org.pepstock.jem.node.persistence.UserPreferencesDBManager;
import org.pepstock.jem.node.persistence.sql.DefaultSQLContainerFactory;
import org.pepstock.jem.node.persistence.sql.MySqlSQLContainerFactory;
import org.pepstock.jem.node.resources.ResourcesUtil;
import org.pepstock.jem.node.resources.custom.ResourceDefinitionException;
import org.pepstock.jem.node.security.keystore.KeysUtil;
import org.pepstock.jem.util.VariableSubstituter;
import org.xml.sax.SAXException;

public class StartUpSystem {
    private static final Properties PROPERTIES = new Properties();
    private static final String SEMAPHORE = "org.pepstock.jem.semaphore";

    public static void run() throws ConfigurationException {
        StartUpSystem.loadConfiguration();
        StartUpSystem.loadEnvConfiguration();
        StartUpSystem.startHazelcast();
        StartUpSystem.deleteNotExistingTypesResources();
        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC012I, ManagementFactory.getRuntimeMXBean().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startHazelcast() throws ConfigurationException {
        LogAppl.getInstance().emit(NodeMessage.JEMC002I);
        ResourcesUtil.getInstance().createKey();
        String hazelcastFile = System.getProperty("hazelcast.config");
        if (hazelcastFile == null) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC005E, "hazelcast.config");
            throw new ConfigurationException(NodeMessage.JEMC005E.toMessage().getFormattedMessage("hazelcast.config"));
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.parse(new FileInputStream(hazelcastFile));
            FileSystemXmlConfig config = new FileSystemXmlConfig(hazelcastFile);
            String pwdFromConfig = config.getGroupConfig().getPassword();
            if (pwdFromConfig == null || pwdFromConfig.trim().equals("")) {
                throw new ConfigurationException(NodeMessage.JEMC108E.toMessage().getFormattedMessage(new Object[0]));
            }
            Main.HAZELCAST_CONFIG = config;
            System.setProperty("hazelcast.shutdownhook.enabled", "false");
            Main.HAZELCAST = Hazelcast.newHazelcastInstance((Config)config);
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException(e);
        }
        catch (ParserConfigurationException e) {
            throw new ConfigurationException(e);
        }
        catch (SAXException e) {
            throw new ConfigurationException(e);
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
        ILock lock = Main.HAZELCAST.getLock((Object)"org.pepstock.jem.startup");
        try {
            lock.lock();
            Cluster cluster = Main.HAZELCAST.getCluster();
            cluster.addMembershipListener((MembershipListener)new NodeListener());
            Member member = cluster.getLocalMember();
            try {
                NodeInfoUtility.loadNodeInfo(member, Main.NODE);
            }
            catch (Exception e) {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC147E, e);
                throw new ConfigurationException(NodeMessage.JEMC147E.toMessage().getMessage(), e);
            }
            NodeInfoUtility.storeNodeInfo(Main.NODE);
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC030I, Main.NODE.getStatus());
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC003I, Main.NODE.getKey());
            String group = Main.HAZELCAST.getConfig().getGroupConfig().getName();
            if (!group.equalsIgnoreCase(Main.EXECUTION_ENVIRONMENT.getEnvironment())) {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC010E, Main.EXECUTION_ENVIRONMENT.getEnvironment(), group);
                throw new ConfigurationException(NodeMessage.JEMC010E.toMessage().getFormattedMessage(Main.EXECUTION_ENVIRONMENT.getEnvironment(), group));
            }
            Member local = cluster.getLocalMember();
            Member first = null;
            for (Member mem : cluster.getMembers()) {
                if (mem.isLiteMember() || first != null) continue;
                first = mem;
            }
            cluster.getMembers().iterator().next();
            if (local.equals(first)) {
                Main.IS_COORDINATOR = true;
                if (Main.JOB_LIFECYCLE_LISTENERS_SYSTEM.hasListeners()) {
                    LogAppl.getInstance().emit(NodeMessage.JEMC034I);
                }
            } else {
                Key key;
                Main.IS_COORDINATOR = false;
                try {
                    key = KeysUtil.getSymmetricKey();
                }
                catch (Exception e) {
                    throw new ConfigurationException(e);
                }
                ResourcesUtil.getInstance().setKey(key);
            }
            StartUpSystem.checkIfEnoughMembers();
            StartUpSystem.loadQueues();
        }
        finally {
            lock.unlock();
        }
    }

    private static void checkIfEnoughMembers() throws ConfigurationException {
        long neededMemory;
        ISemaphore semaphore = Main.HAZELCAST.getSemaphore(SEMAPHORE);
        ArrayList<Status> statusList = new ArrayList<Status>();
        statusList.add(Status.STARTING);
        List<NodeInfo> nodesInfo = NodeInfoUtility.getNodesInfoByStatus(statusList, true, false);
        if (!nodesInfo.isEmpty()) {
            return;
        }
        long queueSize = StartUpSystem.calculateQueueSize() * 2L;
        Cluster cluster = Main.HAZELCAST.getCluster();
        int membersNumber = cluster.getMembers().size();
        for (Member member : cluster.getMembers()) {
            if (!member.isLiteMember()) continue;
            --membersNumber;
        }
        MemoryMXBean bean = ManagementFactory.getMemoryMXBean();
        long freeMemoryForNode = bean.getHeapMemoryUsage().getMax() - bean.getHeapMemoryUsage().getUsed();
        long clusterFreMemory = freeMemoryForNode * (long)membersNumber;
        if (clusterFreMemory > (neededMemory = queueSize + queueSize / 10L * 2L)) {
            semaphore.release(membersNumber - 1);
            return;
        }
        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC086W, clusterFreMemory / 1000L, neededMemory / 1000L);
        try {
            semaphore.acquire();
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    private static long calculateQueueSize() throws ConfigurationException {
        try {
            long inputQueueSize = JobDBManager.getInstance().getInputQueueJobSize();
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC085I, "org.pepstock.jem.input", inputQueueSize / 1000L);
            long runningQueueSize = JobDBManager.getInstance().getRunningQueueJobSize();
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC085I, "org.pepstock.jem.running", runningQueueSize / 1000L);
            long outputQueueSize = JobDBManager.getInstance().getOutputQueueJobSize();
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC085I, "org.pepstock.jem.output", outputQueueSize / 1000L);
            long routingQueueSize = JobDBManager.getInstance().getRoutingQueueJobSize();
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC085I, "org.pepstock.jem.routing", routingQueueSize / 1000L);
            long rolesSize = RolesDBManager.getInstance().getRolesSize();
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC085I, "org.pepstock.jem.roles", rolesSize / 1000L);
            long resourcesSize = CommonResourcesDBManager.getInstance().getCommonResourcesSize();
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC085I, "org.pepstock.jem.common.resources", resourcesSize / 1000L);
            long checkingQueueSize = PreJobDBManager.getInstance().getPreJobsCheckingQueueJobSize();
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC085I, "org.pepstock.jem.jcl.checking", checkingQueueSize / 1000L);
            long routingConfSize = RoutingConfigDBManager.getInstance().getRoutingConfigSize();
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC085I, "org.pepstock.jem.routingConfig", routingConfSize / 1000L);
            long userPrefSize = UserPreferencesDBManager.getInstance().getUserPreferencesSize();
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC085I, "org.pepstock.jem.user.preferences", userPrefSize / 1000L);
            long totlaSize = inputQueueSize + runningQueueSize + outputQueueSize + routingQueueSize + rolesSize + resourcesSize + checkingQueueSize + routingConfSize;
            return totlaSize;
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadQueues() throws ConfigurationException {
        IMap inputQueue = Main.HAZELCAST.getMap("org.pepstock.jem.input");
        inputQueue.size();
        IMap outputQueue = Main.HAZELCAST.getMap("org.pepstock.jem.output");
        outputQueue.size();
        if (Main.IS_COORDINATOR) {
            IMap runningQueue = Main.HAZELCAST.getMap("org.pepstock.jem.running");
            try {
                runningQueue.lockMap(10L, TimeUnit.SECONDS);
                if (!runningQueue.isEmpty()) {
                    for (Job job : runningQueue.values()) {
                        Result result = new Result();
                        result.setReturnCode(12);
                        result.setExceptionMessage("Node is crashed during job was executing");
                        job.setResult(result);
                        job.setEndedTime(new Date());
                        job.setRunningStatus(0);
                        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC190W, job.getName(), job.getId());
                        runningQueue.remove((Object)job.getId());
                        outputQueue.putIfAbsent((Object)job.getId(), (Object)job);
                    }
                }
            }
            finally {
                runningQueue.unlockMap();
            }
        }
        IMap routingQueue = Main.HAZELCAST.getMap("org.pepstock.jem.routing");
        routingQueue.size();
        RecoveryManager.getInstance();
        IMap resourceMap = Main.HAZELCAST.getMap("org.pepstock.jem.common.resources");
        resourceMap.size();
        IMap rolesMap = Main.HAZELCAST.getMap("org.pepstock.jem.roles");
        rolesMap.size();
        IMap routingConfigMap = Main.HAZELCAST.getMap("org.pepstock.jem.routingConfig");
        routingConfigMap.size();
        if (routingConfigMap.isEmpty()) {
            routingConfigMap.put((Object)"ROUTING_CONFIGURATION", (Object)new SwarmConfiguration());
        }
        IMap userPreferencesMap = Main.HAZELCAST.getMap("org.pepstock.jem.user.preferences");
        userPreferencesMap.size();
    }

    private static void loadEnvConfiguration() throws ConfigurationException {
        Object object;
        String configFile = System.getProperty("jem.env");
        if (configFile == null) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC005E, "jem.env");
            throw new ConfigurationException(NodeMessage.JEMC005E.toMessage().getFormattedMessage("jem.config"));
        }
        XStream xstream = new XStream();
        xstream.alias("configuration", Configuration.class);
        xstream.aliasField("statistics-manager", Configuration.class, "statsManager");
        xstream.alias("node", Node.class);
        xstream.alias("database", Database.class);
        xstream.alias("factory", Factory.class);
        xstream.aliasAttribute(Factory.class, "className", "className");
        xstream.alias("listener", Listener.class);
        xstream.aliasAttribute(Listener.class, "className", "className");
        xstream.aliasAttribute(StatsManager.class, "path", "path");
        xstream.aliasAttribute(StatsManager.class, "enable", "enable");
        xstream.alias("resource-definition", CustomResourceDefinition.class);
        xstream.aliasAttribute(CustomResourceDefinition.class, "className", "className");
        xstream.aliasField("resource-definitions", Configuration.class, "resourceDefinitions");
        try {
            object = xstream.fromXML((InputStream)new FileInputStream(configFile));
        }
        catch (Exception e1) {
            LogAppl.getInstance().emit(NodeMessage.JEMC006E);
            throw new ConfigurationException(NodeMessage.JEMC006E.toMessage().getMessage(), e1);
        }
        if (!(object instanceof Configuration)) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC009E, "configuration");
            throw new ConfigurationException(NodeMessage.JEMC009E.toMessage().getFormattedMessage("configuration"));
        }
        Configuration conf = (Configuration)object;
        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC008I, configFile);
        StartUpSystem.loadDatabaseManagers(conf);
        StartUpSystem.loadNode(conf);
        StartUpSystem.loadFactories(conf);
        StartUpSystem.loadListeners(conf);
        StartUpSystem.loadStatisticsManager(conf);
        StartUpSystem.loadResourceConfigurations(conf);
    }

    private static void loadConfiguration() throws ConfigurationException {
        Object object;
        StartUpSystem.handleEnvironmentVariable("JEM_NODE", "JEM_HOME", "JEM_ENVIRONMENT");
        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC192I, System.getProperty("java.version"), System.getProperty("java.home"), System.getProperty("java.vendor"));
        LogAppl.getInstance().emit(NodeMessage.JEMC001I);
        PROPERTIES.putAll((Map<?, ?>)System.getProperties());
        PROPERTIES.putAll(System.getenv());
        String configFile = System.getProperty("jem.config");
        if (configFile == null) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC005E, "jem.config");
            throw new ConfigurationException(NodeMessage.JEMC005E.toMessage().getFormattedMessage("jem.config"));
        }
        XStream xstream = new XStream();
        xstream.alias("configuration", Configuration.class);
        xstream.aliasField("execution-environment", Configuration.class, "executionEnviroment");
        xstream.alias("affinity-factory", AffinityFactory.class);
        xstream.alias("factory", Factory.class);
        xstream.aliasAttribute(Factory.class, "className", "className");
        try {
            object = xstream.fromXML((InputStream)new FileInputStream(configFile));
        }
        catch (Exception e1) {
            LogAppl.getInstance().emit(NodeMessage.JEMC006E);
            throw new ConfigurationException(NodeMessage.JEMC006E.toMessage().getMessage(), e1);
        }
        if (!(object instanceof Configuration)) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC009E, "configuration");
            throw new ConfigurationException(NodeMessage.JEMC009E.toMessage().getFormattedMessage("configuration"));
        }
        Configuration conf = (Configuration)object;
        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC008I, configFile);
        StartUpSystem.loadPaths(conf);
        PROPERTIES.putAll((Map<?, ?>)System.getProperties());
        StartUpSystem.loadExecutionEnvironment(conf);
    }

    private static void loadPaths(Configuration conf) throws ConfigurationException {
        Paths paths = conf.getPaths();
        if (paths == null) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC009E, "paths");
            throw new ConfigurationException(NodeMessage.JEMC009E.toMessage().getFormattedMessage("paths"));
        }
        String dataPath = paths.getData();
        String outputPath = paths.getOutput();
        String binaryPath = paths.getBinary();
        String classpathPath = paths.getClasspath();
        String libraryPath = paths.getLibrary();
        String persistencePath = paths.getPersistence();
        String sourcetPath = paths.getSource();
        if (outputPath == null) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC039E, "jem.output");
            throw new ConfigurationException(NodeMessage.JEMC039E.toMessage().getFormattedMessage("jem.output"));
        }
        if (dataPath == null) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC039E, "jem.data");
            throw new ConfigurationException(NodeMessage.JEMC039E.toMessage().getFormattedMessage("jem.data"));
        }
        if (binaryPath == null) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC039E, "jem.binary");
            throw new ConfigurationException(NodeMessage.JEMC039E.toMessage().getFormattedMessage("jem.binary"));
        }
        if (classpathPath == null) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC039E, "jem.classpath");
            throw new ConfigurationException(NodeMessage.JEMC039E.toMessage().getFormattedMessage("jem.classpath"));
        }
        if (libraryPath == null) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC039E, "jem.library");
            throw new ConfigurationException(NodeMessage.JEMC039E.toMessage().getFormattedMessage("jem.library"));
        }
        if (persistencePath == null) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC039E, "jem.persistence");
            throw new ConfigurationException(NodeMessage.JEMC039E.toMessage().getFormattedMessage("jem.persistence"));
        }
        if (sourcetPath == null) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC039E, "jem.source");
            throw new ConfigurationException(NodeMessage.JEMC039E.toMessage().getFormattedMessage("jem.source"));
        }
        dataPath = StartUpSystem.substituteVariable(dataPath);
        System.getProperties().setProperty("jem.data", StartUpSystem.normalizePath(dataPath));
        outputPath = StartUpSystem.substituteVariable(outputPath);
        System.getProperties().setProperty("jem.output", StartUpSystem.normalizePath(outputPath));
        binaryPath = StartUpSystem.substituteVariable(binaryPath);
        System.getProperties().setProperty("jem.binary", StartUpSystem.normalizePath(binaryPath));
        classpathPath = StartUpSystem.substituteVariable(classpathPath);
        System.getProperties().setProperty("jem.classpath", StartUpSystem.normalizePath(classpathPath));
        System.getProperties().setProperty("jem.library", StartUpSystem.normalizePath(libraryPath));
        persistencePath = StartUpSystem.substituteVariable(persistencePath);
        System.getProperties().setProperty("jem.persistence", StartUpSystem.normalizePath(persistencePath));
        sourcetPath = StartUpSystem.substituteVariable(sourcetPath);
        System.getProperties().setProperty("jem.source", StartUpSystem.normalizePath(sourcetPath));
        Main.OUTPUT_SYSTEM = new OutputSystem(outputPath, dataPath, persistencePath);
    }

    private static String substituteVariable(String string) {
        return VariableSubstituter.substitute(string, PROPERTIES);
    }

    private static void loadListeners(Configuration conf) throws ConfigurationException {
        ArrayList<Listener> listeners = conf.getListeners();
        if (listeners != null && !listeners.isEmpty()) {
            for (Listener listener : listeners) {
                if (listener.getClassName() != null) {
                    String className = listener.getClassName();
                    try {
                        Object objectListener = Class.forName(className).newInstance();
                        if (objectListener instanceof JobLifecycleListener) {
                            JobLifecycleListener lister = (JobLifecycleListener)objectListener;
                            Main.JOB_LIFECYCLE_LISTENERS_SYSTEM.addListener(JobLifecycleListener.class, lister);
                            Properties propsOfListener = listener.getProperties();
                            if (!propsOfListener.isEmpty()) {
                                Enumeration<Object> e = propsOfListener.keys();
                                while (e.hasMoreElements()) {
                                    String key = e.nextElement().toString();
                                    String value = propsOfListener.getProperty(key);
                                    propsOfListener.setProperty(key, StartUpSystem.substituteVariable(value));
                                }
                            }
                            lister.init(propsOfListener);
                            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC037I, className);
                            continue;
                        }
                        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC036E, className);
                        throw new ConfigurationException(NodeMessage.JEMC036E.toMessage().getFormattedMessage(className));
                    }
                    catch (ClassNotFoundException e) {
                        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC031E, e, className);
                        throw new ConfigurationException(NodeMessage.JEMC031E.toMessage().getFormattedMessage(className));
                    }
                    catch (InstantiationException e) {
                        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC031E, e, className);
                        throw new ConfigurationException(NodeMessage.JEMC031E.toMessage().getFormattedMessage(className));
                    }
                    catch (IllegalAccessException e) {
                        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC031E, e, className);
                        throw new ConfigurationException(NodeMessage.JEMC031E.toMessage().getFormattedMessage(className));
                    }
                }
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC038W, "listener", listener.toString());
            }
        }
    }

    private static void loadResourceConfigurations(Configuration conf) throws ConfigurationException {
        ArrayList<CustomResourceDefinition> resourceDefinitions = conf.getResourceDefinitions();
        if (resourceDefinitions != null && !resourceDefinitions.isEmpty()) {
            for (CustomResourceDefinition resourceDefinition : resourceDefinitions) {
                if (resourceDefinition.getClassName() != null) {
                    Properties propsOfListener = resourceDefinition.getProperties();
                    String xmlResourceTemplateFile = propsOfListener.getProperty("jem.xml.resource.template.file");
                    if (null != xmlResourceTemplateFile) {
                        xmlResourceTemplateFile = StartUpSystem.substituteVariable(xmlResourceTemplateFile);
                    }
                    try {
                        Main.CUSTOM_RESOURCE_DEFINITION_MANAGER.loadCustomResourceDefinition(resourceDefinition, xmlResourceTemplateFile);
                        continue;
                    }
                    catch (ResourceDefinitionException e) {
                        throw new ConfigurationException(e);
                    }
                }
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC038W, "resource-definition", resourceDefinition.toString());
            }
        }
    }

    private static void deleteNotExistingTypesResources() throws ConfigurationException {
        try {
            Main.CUSTOM_RESOURCE_DEFINITION_MANAGER.deleteNotExistingTypesResources();
        }
        catch (ResourceDefinitionException e) {
            throw new ConfigurationException(e);
        }
    }

    private static void loadDatabaseManagers(Configuration conf) throws ConfigurationException {
        Database database = conf.getDatabase();
        if (database == null) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC009E, "database");
            throw new ConfigurationException(NodeMessage.JEMC009E.toMessage().getFormattedMessage("database"));
        }
        String url = StartUpSystem.substituteVariable(database.getUrl());
        database.setUrl(url);
        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC193I, url);
        String user = StartUpSystem.substituteVariable(database.getUser());
        database.setUser(user);
        String dbType = null;
        try {
            URI url1 = new URI(database.getUrl());
            URI myURL = new URI(url1.getSchemeSpecificPart());
            dbType = myURL.getScheme();
        }
        catch (URISyntaxException e2) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC166E, e2, database.getUrl());
            throw new ConfigurationException(NodeMessage.JEMC166E.toMessage().getFormattedMessage(database.getUrl()));
        }
        DefaultSQLContainerFactory engine = null;
        engine = dbType.equals("mysql") ? new MySqlSQLContainerFactory() : new DefaultSQLContainerFactory();
        try {
            DBPoolManager.getInstance().setDriver(database.getDriver());
            DBPoolManager.getInstance().setUrl(database.getUrl());
            DBPoolManager.getInstance().setUser(database.getUser());
            DBPoolManager.getInstance().setPassword(database.getPassword());
            DBPoolManager.getInstance().setProperties(database.getProperties());
            DBPoolManager.getInstance().setKeepAliveConnectionSQL(engine.getKeepAliveConnectionSQL());
            DBPoolManager.getInstance().init();
            JobDBManager.getInstance().setInputSqlContainer(engine.getSQLContainerForInputQueue());
            JobDBManager.getInstance().setRunningSqlContainer(engine.getSQLContainerForRunningQueue());
            JobDBManager.getInstance().setOutputSqlContainer(engine.getSQLContainerForOutputQueue());
            JobDBManager.getInstance().setRoutingSqlContainer(engine.getSQLContainerForRoutingQueue());
            PreJobDBManager.getInstance().setCheckingSqlContainer(engine.getSQLContainerForCheckingQueue());
            RolesDBManager.getInstance().setRolesSqlContainer(engine.getSQLContainerForRolesMap());
            CommonResourcesDBManager.getInstance().setCommonResourcesSqlContainer(engine.getSQLContainerForCommonResourcesMap());
            RoutingConfigDBManager.getInstance().setRoutingSqlContainer(engine.getSQLContainerForRoutingConfigMap());
            UserPreferencesDBManager.getInstance().setPreferencesSqlContainer(engine.getSQLContainerForUserPreferencesMap());
            Connection conn = DBPoolManager.getInstance().getConnection();
            try {
                DatabaseMetaData md = conn.getMetaData();
                StartUpSystem.checkAndCreateTable(md, JobDBManager.getInstance().getInputSqlContainer());
                StartUpSystem.checkAndCreateTable(md, JobDBManager.getInstance().getRunningSqlContainer());
                StartUpSystem.checkAndCreateTable(md, JobDBManager.getInstance().getOutputSqlContainer());
                StartUpSystem.checkAndCreateTable(md, JobDBManager.getInstance().getRoutingSqlContainer());
                StartUpSystem.checkAndCreateTable(md, PreJobDBManager.getInstance().getCheckingSqlContainer());
                StartUpSystem.checkAndCreateTable(md, RolesDBManager.getInstance().getRolesSqlContainer());
                StartUpSystem.checkAndCreateTable(md, CommonResourcesDBManager.getInstance().getCommonResourcesSqlContainer());
                StartUpSystem.checkAndCreateTable(md, RoutingConfigDBManager.getInstance().getRoutingSqlContainer());
                StartUpSystem.checkAndCreateTable(md, UserPreferencesDBManager.getInstance().getPreferencesSqlContainer());
            }
            catch (SQLException e1) {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC167E, e1);
                throw new ConfigurationException(NodeMessage.JEMC167E.toMessage().getFormattedMessage(new Object[0]));
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (SQLException e) {
            throw new ConfigurationException(NodeMessage.JEMC165E.toMessage().getFormattedMessage(JobDBManager.class.getName()), e);
        }
    }

    private static void checkAndCreateTable(DatabaseMetaData md, SQLContainer container) throws SQLException {
        ResultSet rs = md.getTables(null, null, container.getTableName(), new String[]{"TABLE"});
        if (!rs.next()) {
            DBPoolManager.getInstance().create(container.getCreateTableStatement());
        }
    }

    private static void loadFactories(Configuration conf) throws ConfigurationException {
        ArrayList<Factory> factories = conf.getFactories();
        if (factories == null) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC009E, "factories");
            throw new ConfigurationException(NodeMessage.JEMC009E.toMessage().getFormattedMessage("factories"));
        }
        if (factories.isEmpty()) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC009E, "factory");
            throw new ConfigurationException(NodeMessage.JEMC009E.toMessage().getFormattedMessage("factory"));
        }
        for (Factory factory : factories) {
            if (factory.getClassName() != null) {
                String className = factory.getClassName();
                try {
                    Object objectFactory = Class.forName(className).newInstance();
                    if (objectFactory instanceof JemFactory) {
                        JemFactory jf = (JemFactory)objectFactory;
                        Properties propsOfFactory = factory.getProperties();
                        if (!propsOfFactory.isEmpty()) {
                            Enumeration<Object> e = propsOfFactory.keys();
                            while (e.hasMoreElements()) {
                                String key = e.nextElement().toString();
                                String value = propsOfFactory.getProperty(key);
                                propsOfFactory.setProperty(key, StartUpSystem.substituteVariable(value));
                            }
                        }
                        jf.init(propsOfFactory);
                        Main.FACTORIES_LIST.put(jf.getType().toLowerCase(), jf);
                        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC032I, className, jf.getType());
                        continue;
                    }
                    LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC040E, className);
                }
                catch (Exception e) {
                    LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC031E, e, className);
                }
                continue;
            }
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC038W, "factory", factory.toString());
        }
    }

    private static void loadExecutionEnvironment(Configuration conf) throws ConfigurationException {
        block14: {
            if (conf.getExecutionEnviroment() == null) {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC009E, "execution-environment");
                throw new ConfigurationException(NodeMessage.JEMC009E.toMessage().getFormattedMessage("execution-environment"));
            }
            if (conf.getExecutionEnviroment().getEnvironment() == null) {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC009E, "environment");
                throw new ConfigurationException(NodeMessage.JEMC009E.toMessage().getFormattedMessage("environment"));
            }
            if (conf.getExecutionEnviroment().getDomain() == null) {
                conf.getExecutionEnviroment().setDomain("***");
            }
            if (conf.getExecutionEnviroment().getAffinity() == null) {
                conf.getExecutionEnviroment().setAffinity("***");
            }
            String environment = conf.getExecutionEnviroment().getEnvironment();
            conf.getExecutionEnviroment().setEnvironment(StartUpSystem.substituteVariable(environment));
            Main.EXECUTION_ENVIRONMENT.setEnvironment(conf.getExecutionEnviroment().getEnvironment());
            String domain = conf.getExecutionEnviroment().getDomain();
            conf.getExecutionEnviroment().setDomain(StartUpSystem.substituteVariable(domain));
            Main.EXECUTION_ENVIRONMENT.setDomain(conf.getExecutionEnviroment().getDomain());
            String affinity = conf.getExecutionEnviroment().getAffinity();
            conf.getExecutionEnviroment().setAffinity(StartUpSystem.substituteVariable(affinity));
            String[] affinities = conf.getExecutionEnviroment().getAffinity().split(",");
            for (int i = 0; i < affinities.length; ++i) {
                Main.EXECUTION_ENVIRONMENT.getStaticAffinities().add(affinities[i].trim().toLowerCase());
            }
            AffinityFactory affinityFactory = conf.getExecutionEnviroment().getAffinityFactory();
            if (affinityFactory != null) {
                if (affinityFactory.getClassName() != null) {
                    String className = affinityFactory.getClassName();
                    try {
                        Object objectFactory = Class.forName(className).newInstance();
                        if (objectFactory instanceof AffinityLoader) {
                            AffinityLoader loader = (AffinityLoader)objectFactory;
                            Properties propsOfFactory = affinityFactory.getProperties();
                            if (!propsOfFactory.isEmpty()) {
                                Enumeration<Object> e = propsOfFactory.keys();
                                while (e.hasMoreElements()) {
                                    String key = e.nextElement().toString();
                                    String value = propsOfFactory.getProperty(key);
                                    propsOfFactory.setProperty(key, StartUpSystem.substituteVariable(value));
                                }
                            }
                            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC049I, className);
                            loader.init(propsOfFactory);
                            org.pepstock.jem.node.affinity.Result result = loader.load(new SystemInfo());
                            if (result != null) {
                                Main.EXECUTION_ENVIRONMENT.getDynamicAffinities().addAll(result.getAffinities());
                                Main.EXECUTION_ENVIRONMENT.setMemory(result.getMemory());
                            }
                            Main.AFFINITY_LOADER = loader;
                            break block14;
                        }
                        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC089E, className);
                    }
                    catch (Exception e) {
                        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC031E, e, className);
                    }
                } else {
                    LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC038W, "factory", affinityFactory.toString());
                }
            }
        }
        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC050I, Main.EXECUTION_ENVIRONMENT);
    }

    private static void loadStatisticsManager(Configuration conf) throws ConfigurationException {
        StatsManager statsManager = conf.getStatsManager();
        if (statsManager != null) {
            if (!statsManager.isEnable()) {
                Main.STATISTICS_MANAGER = new StatisticsManager(false);
            } else {
                String path = statsManager.getPath();
                if (path != null) {
                    path = StartUpSystem.substituteVariable(path);
                }
                Main.STATISTICS_MANAGER = new StatisticsManager(true, path);
            }
        } else {
            Main.STATISTICS_MANAGER = new StatisticsManager();
        }
    }

    private static void loadNode(Configuration conf) throws ConfigurationException {
        Node node = conf.getNode();
        if (node != null && node.getClassName() != null) {
            String className = node.getClassName();
            try {
                Object objectNode = Class.forName(className).newInstance();
                if (objectNode instanceof NodeInfo) {
                    Main.NODE = (NodeInfo)objectNode;
                    Properties propsOfNode = node.getProperties();
                    if (!propsOfNode.isEmpty()) {
                        Enumeration<Object> e = propsOfNode.keys();
                        while (e.hasMoreElements()) {
                            String key = e.nextElement().toString();
                            String value = propsOfNode.getProperty(key);
                            propsOfNode.setProperty(key, StartUpSystem.substituteVariable(value));
                        }
                    }
                    Main.NODE.init(propsOfNode);
                    LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC090I, className);
                    return;
                }
                LogAppl.getInstance().emit(NodeMessage.JEMC091E);
                throw new ConfigurationException(NodeMessage.JEMC091E.toMessage().getFormattedMessage(className));
            }
            catch (Exception e) {
                throw new ConfigurationException(e);
            }
        }
        Main.NODE = new NodeInfo();
        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC090I, NodeInfo.class.getName());
    }

    private static void handleEnvironmentVariable(String ... variables) throws ConfigurationException {
        for (int i = 0; i < variables.length; ++i) {
            String variable = System.getenv().get(variables[i]);
            if (variable == null) {
                String key = null;
                key = variables[i].equals("JEM_HOME") ? variables[i].toLowerCase() : "wrapper.app.env." + variables[i].toLowerCase();
                variable = System.getenv().get(key);
                if (variable == null) {
                    LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC058E, variables[i]);
                    throw new ConfigurationException(NodeMessage.JEMC058E.toMessage().getFormattedMessage(variables[i]));
                }
            }
            System.getProperties().setProperty(variables[i], StartUpSystem.normalizePath(variable));
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC057I, variables[i], variable);
        }
    }

    private static String normalizePath(String path) {
        File file = new File(path);
        String normalized = FilenameUtils.normalize((String)file.getAbsolutePath(), (boolean)true);
        return normalized;
    }
}

