/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node;

import com.hazelcast.core.ILock;
import org.apache.commons.lang3.StringUtils;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.InputQueueManager;
import org.pepstock.jem.node.JclCheckingQueueManager;
import org.pepstock.jem.node.Main;
import org.pepstock.jem.node.NodeInfoUtility;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.Status;
import org.pepstock.jem.node.Submitter;
import org.pepstock.jem.node.persistence.DBPoolManager;

public class ShutDownHandler
extends Thread {
    private JclCheckingQueueManager jclCheckManager = null;
    private Submitter submitter = null;

    public ShutDownHandler(JclCheckingQueueManager jclCheckManager, Submitter submitter) {
        super(ShutDownHandler.class.getName());
        this.jclCheckManager = jclCheckManager;
        this.submitter = submitter;
    }

    @Override
    public void run() {
        ILock shutdownSynch = null;
        if (Main.NODE != null) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC071I, Main.NODE.getLabel());
            if (Main.HAZELCAST != null) {
                shutdownSynch = Main.HAZELCAST.getLock((Object)"org.pepstock.jem.shutdown");
                shutdownSynch.lock();
            }
            Main.IS_SHUTTING_DOWN = true;
            NodeInfoUtility.drain();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            while (!Main.NODE.getStatus().equals(Status.DRAINED)) {
                if (Main.CURRENT_TASK != null) {
                    LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC072I, Main.CURRENT_TASK.getJobTask().getJob().toString());
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {}
            }
        }
        if (this.jclCheckManager != null) {
            try {
                this.jclCheckManager.shutdown();
            }
            catch (Exception e) {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC162E, e, StringUtils.substringAfterLast((String)JclCheckingQueueManager.class.getName(), (String)"."));
            }
        }
        if (Main.INPUT_QUEUE_MANAGER != null) {
            try {
                Main.INPUT_QUEUE_MANAGER.shutdown();
            }
            catch (Exception e) {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC162E, e, StringUtils.substringAfterLast((String)InputQueueManager.class.getName(), (String)"."));
            }
        }
        if (this.submitter != null) {
            try {
                this.submitter.shutdown();
            }
            catch (Exception e) {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC162E, e, StringUtils.substringAfterLast((String)Submitter.class.getName(), (String)"."));
            }
        }
        if (Main.STATISTICS_MANAGER != null) {
            Main.STATISTICS_MANAGER.stop();
        }
        if (Main.HAZELCAST != null) {
            Main.HAZELCAST.getLifecycleService().shutdown();
        }
        try {
            DBPoolManager.getInstance().close();
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC069I, StringUtils.substringAfterLast((String)DBPoolManager.class.getName(), (String)"."));
        }
        catch (Exception e) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC070E, e, StringUtils.substringAfterLast((String)DBPoolManager.class.getName(), (String)"."));
        }
    }
}

