/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node;

import com.hazelcast.core.MapEntry;
import com.hazelcast.query.Predicates;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.pepstock.jem.Jcl;
import org.pepstock.jem.Job;

public class RoutingQueuePredicate
extends Predicates.AbstractPredicate {
    private static final long serialVersionUID = 1L;
    private Set<String> environments = null;

    public Set<String> getEnvironments() {
        return this.environments;
    }

    public void setEnvironments(Set<String> environments) {
        this.environments = environments;
    }

    public boolean apply(MapEntry arg0) {
        Job job = (Job)arg0.getValue();
        if (job == null) {
            return false;
        }
        Jcl jcl = job.getJcl();
        if (jcl == null) {
            return false;
        }
        if (!jcl.isHold()) {
            if (job.getRoutingInfo() == null) {
                return false;
            }
            if (job.getRoutingInfo().isRoutingCommitted() == null) {
                Iterator<String> envsIter = this.environments.iterator();
                while (envsIter.hasNext()) {
                    if (!envsIter.next().equalsIgnoreCase(jcl.getEnvironment())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void readData(DataInput arg0) throws IOException {
        String ee = arg0.readLine();
        String setString = ee.substring(1, ee.length() - 1);
        String[] tokens = setString.split(",");
        this.environments = new HashSet<String>();
        for (String currToken : tokens) {
            this.environments.add(currToken.trim());
        }
    }

    public void writeData(DataOutput arg0) throws IOException {
        String ee = this.environments.toString();
        arg0.writeBytes(ee);
    }
}

