/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.io.FileSystemUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.math3.stat.regression.OLSMultipleLinearRegression;
import org.pepstock.jem.Job;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.Main;
import org.pepstock.jem.node.NodeInfoUtility;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.Status;
import org.pepstock.jem.node.configuration.ConfigurationException;
import org.pepstock.jem.util.DateFormatter;

public class OutputSystem {
    public static final String CURRENT_PATH = "./";
    public static final String JCL_FILE = "jcl.xml";
    public static final String JOB_FILE = "job.xml";
    public static final String JOB_LOG_TYPE = "job";
    public static final String JOBLOG_FILE = "job.log";
    public static final String MESSAGES_LOG_TYPE = "message";
    public static final String MESSAGESLOG_FILE = "messages.log";
    private File currentPath = new File("./");
    private File outputPath = null;
    private File dataPath = null;
    private File persistencePath = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OutputSystem(String output_path, String data_path, String persistence_path) throws ConfigurationException {
        if (!this.currentPath.exists()) {
            throw new ConfigurationException(NodeMessage.JEMC099E.toMessage().getFormattedMessage(CURRENT_PATH));
        }
        this.outputPath = new File(output_path);
        if (!this.outputPath.exists()) {
            boolean isCreated = this.outputPath.mkdir();
            if (!isCreated) throw new ConfigurationException(NodeMessage.JEMC153E.toMessage().getFormattedMessage(this.outputPath));
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC026I, this.outputPath.getAbsolutePath());
        } else if (!this.outputPath.isDirectory()) {
            throw new ConfigurationException(NodeMessage.JEMC098E.toMessage().getFormattedMessage(this.outputPath));
        }
        this.dataPath = new File(data_path);
        if (!this.dataPath.exists()) {
            throw new ConfigurationException(NodeMessage.JEMC099E.toMessage().getFormattedMessage(this.dataPath));
        }
        if (!this.dataPath.isDirectory()) {
            throw new ConfigurationException(NodeMessage.JEMC098E.toMessage().getFormattedMessage(this.dataPath));
        }
        this.persistencePath = new File(persistence_path);
        if (!this.persistencePath.exists()) {
            throw new ConfigurationException(NodeMessage.JEMC099E.toMessage().getFormattedMessage(this.persistencePath));
        }
        if (!this.persistencePath.isDirectory()) {
            throw new ConfigurationException(NodeMessage.JEMC098E.toMessage().getFormattedMessage(this.persistencePath));
        }
        String className = FilenameUtils.getExtension((String)this.getClass().getName());
        Timer timer = new Timer(className, false);
        timer.schedule((TimerTask)new GlobalFileSystemHealthCheck(), 20000L, 60000L);
    }

    public File getCurrentPath() {
        return this.currentPath;
    }

    public File getPersistencePath() {
        return this.persistencePath;
    }

    public File getOutputPath() {
        return this.outputPath;
    }

    public File getOutputPath(Job job) {
        return new File(this.outputPath, job.getId());
    }

    public File getDataPath() {
        return this.dataPath;
    }

    private File createDirectoryForJob(Job job, boolean createDirectory) throws IOException {
        boolean isCreated;
        File dirJob = this.getOutputPath(job);
        if (!dirJob.exists() && createDirectory && !(isCreated = dirJob.mkdir())) {
            throw new IOException(NodeMessage.JEMC153E.toMessage().getFormattedMessage(dirJob.getAbsolutePath()));
        }
        return dirJob;
    }

    public File getJclFile(Job job) throws IOException {
        File dirJob = this.createDirectoryForJob(job, true);
        File file = new File(dirJob, JCL_FILE);
        return file;
    }

    public File getJobFile(Job job) throws IOException {
        File dirJob = this.createDirectoryForJob(job, true);
        File file = new File(dirJob, JOB_FILE);
        return file;
    }

    public File getJobLogFile(Job job, boolean createDirectory) throws IOException {
        File dirJob = this.createDirectoryForJob(job, createDirectory);
        File file = new File(dirJob, JOBLOG_FILE);
        return file;
    }

    public File getJobLogFile(Job job) throws IOException {
        return this.getJobLogFile(job, true);
    }

    public File getMessagesLogFile(Job job) throws IOException {
        return this.getMessagesLogFile(job, true);
    }

    public File getMessagesLogFile(Job job, boolean createDirectory) throws IOException {
        File dirJob = this.createDirectoryForJob(job, true);
        File file = new File(dirJob, MESSAGESLOG_FILE);
        return file;
    }

    public void writeJcl(Job job) throws IOException {
        PrintStream fos = new PrintStream(new FileOutputStream(this.getJclFile(job)));
        fos.print(job.getJcl().getContent());
        fos.flush();
        fos.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeJob(Job job) {
        PrintStream fos = null;
        try {
            fos = new PrintStream(new FileOutputStream(this.getJobFile(job)));
            XStream xs = new XStream();
            xs.toXML((Object)job, (OutputStream)fos);
            fos.flush();
            fos.close();
        }
        catch (FileNotFoundException e) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC168E, e);
        }
        catch (IOException e) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC168E, e);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeJobLog(Job job, String record) {
        PrintStream fos = null;
        try {
            File file = this.getJobLogFile(job);
            fos = file.exists() ? new PrintStream(new FileOutputStream(file, true)) : new PrintStream(new FileOutputStream(file));
            fos.print(DateFormatter.getCurrentDate("yyyy MM dd HH:mm:ss   "));
            fos.println(record);
            fos.flush();
        }
        catch (FileNotFoundException e) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC027E, e);
        }
        catch (IOException e) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC027E, e);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMessageLog(Job job, String record) {
        PrintStream fos = null;
        try {
            File file = this.getMessagesLogFile(job);
            fos = file.exists() ? new PrintStream(new FileOutputStream(file, true)) : new PrintStream(new FileOutputStream(file));
            fos.print(record);
            fos.flush();
        }
        catch (FileNotFoundException e) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC027E, e);
        }
        catch (IOException e) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC027E, e);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    static class Space {
        private long space = 0L;
        private long time = 0L;

        Space() {
        }

        public long getSpace() {
            return this.space;
        }

        public void setSpace(long space) {
            this.space = space;
        }

        public long getTime() {
            return this.time;
        }

        public void setTime(long time) {
            this.time = time;
        }

        public String toString() {
            return "Space [space=" + this.space + ", time=" + this.time + "]";
        }
    }

    class GlobalFileSystemHealthCheck
    extends TimerTask {
        private static final long MINUTE = 60L;
        private static final int SAMPLES_COUNT = 10;
        private static final long MB = 1024L;
        private LinkedList<Space> list = new LinkedList();

        GlobalFileSystemHealthCheck() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (Main.IS_SHUTTING_DOWN) {
                return;
            }
            if (Main.NODE != null) {
                Main.NODE.getLock().lock();
                try {
                    long freeSpace = FileSystemUtils.freeSpaceKb((String)OutputSystem.this.outputPath.getAbsolutePath(), (long)10000L);
                    Space space = new Space();
                    space.setSpace(freeSpace);
                    space.setTime(System.currentTimeMillis() / 1000L);
                    this.list.addLast(space);
                    if (this.list.size() > 10) {
                        this.list.removeFirst();
                    }
                    if (this.isUnderThreshold()) {
                        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC182E, String.valueOf(freeSpace));
                        if (Main.NODE.getStatus().equals(Status.INACTIVE) || Main.NODE.getStatus().equals(Status.ACTIVE)) {
                            NodeInfoUtility.drain();
                        }
                    }
                }
                catch (Exception e) {
                    LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC181E, e);
                }
                finally {
                    Main.NODE.getLock().unlock();
                }
            }
        }

        private boolean isUnderThreshold() {
            if (this.list.size() == 1) {
                Space space = this.list.getFirst();
                return space.getSpace() < 102400L;
            }
            double[] values = new double[this.list.size()];
            double[][] times = new double[this.list.size()][];
            int index = 0;
            for (Space space : this.list) {
                values[index] = space.getSpace();
                times[index] = new double[]{space.getTime()};
                ++index;
            }
            OLSMultipleLinearRegression model = new OLSMultipleLinearRegression();
            model.newSampleData(values, (double[][])times);
            double[] betaHat = model.estimateRegressionParameters();
            double m = betaHat[1];
            double q = betaHat[0];
            Space last = this.list.getLast();
            double x = last.getTime() + 600L;
            double y = m * x + q;
            return y < 102400.0;
        }
    }
}

