/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node;

import com.hazelcast.core.DistributedTask;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Member;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.SqlPredicate;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.apache.commons.lang3.StringUtils;
import org.hyperic.sigar.ProcCredName;
import org.hyperic.sigar.Sigar;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.Main;
import org.pepstock.jem.node.NodeInfo;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.Status;
import org.pepstock.jem.node.configuration.ConfigurationException;
import org.pepstock.jem.node.executors.GenericCallBack;
import org.pepstock.jem.node.executors.nodes.Drain;
import org.pepstock.jem.node.executors.nodes.Start;
import org.pepstock.jem.util.Parser;

public class NodeInfoUtility {
    private static Sigar SIGAR = new Sigar();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void loadNodeInfo(Member member, NodeInfo info) throws Exception {
        ZipFile jarFile = null;
        try {
            jarFile = new JarFile(new File(Main.class.getProtectionDomain().getCodeSource().getLocation().toURI()));
            Attributes at = ((JarFile)jarFile).getManifest().getAttributes("JEM_the_BEE");
            String jemVersion = at.getValue("Jem_version");
            if (jemVersion != null) {
                info.setJemVersion(jemVersion);
            }
        }
        catch (IOException e) {
            LogAppl.getInstance().emit(NodeMessage.JEMC184W);
        }
        catch (URISyntaxException e) {
            LogAppl.getInstance().emit(NodeMessage.JEMC184W);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException e) {}
            }
        }
        info.setKey(member.getUuid());
        info.setStatus(Status.STARTING);
        info.setSuperNode(member.isLiteMember());
        InetSocketAddress address = member.getInetSocketAddress();
        info.setPort(address.getPort());
        info.setIpaddress(address.getAddress().getHostAddress());
        info.setLabel(info.getIpaddress() + ":" + info.getPort());
        info.setExecutionEnvironment(Main.EXECUTION_ENVIRONMENT);
        info.setProcessId(ManagementFactory.getRuntimeMXBean().getName());
        String hostname = StringUtils.substringAfter((String)info.getProcessId(), (String)"@");
        info.setHostname(hostname);
        OperatingSystemMXBean bean = ManagementFactory.getOperatingSystemMXBean();
        info.getNodeInfoBean().setSystemArchitecture(bean.getArch());
        info.getNodeInfoBean().setAvailableProcessors(bean.getAvailableProcessors());
        info.getNodeInfoBean().setSystemName(bean.getName());
        info.getNodeInfoBean().setTotalMemory(SIGAR.getMem().getTotal());
        ProcCredName cred = SIGAR.getProcCredName(SIGAR.getPid());
        info.setUser(cred.getUser());
        if (!member.isLiteMember()) {
            info.getRequest().setRequestorId(info.getKey());
            info.getRequest().setRequestorName(info.getLabel());
        }
        info.loaded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void checkAndStoreNodeInfo(NodeInfo info) throws ConfigurationException {
        IMap members_map = Main.HAZELCAST.getMap("org.pepstock.jem.nodes");
        StringBuffer sb = new StringBuffer();
        sb.append("label = '").append(info.getLabel()).append("'");
        Collection nodeInfos = members_map.values((Predicate)new SqlPredicate(sb.toString()));
        try {
            members_map.lock((Object)info.getKey());
            if (!nodeInfos.isEmpty()) {
                for (NodeInfo prevNodeInfo : nodeInfos) {
                    members_map.remove((Object)prevNodeInfo.getKey());
                }
            }
            members_map.put((Object)info.getKey(), (Object)info);
            boolean checkVersion = Parser.parseBoolean(System.getProperty("jem.check.version"), false);
            Collection allNodes = members_map.values();
            for (NodeInfo currNodeInfo : allNodes) {
                if (currNodeInfo.isSuperNode() || currNodeInfo.getJemVersion().equals(info.getJemVersion())) continue;
                if (checkVersion) {
                    throw new ConfigurationException(NodeMessage.JEMC191E.toMessage().getFormattedMessage(new Object[0]));
                }
                LogAppl.getInstance().emit(NodeMessage.JEMC185W);
                break;
            }
        }
        catch (Exception ex) {
            if (ex instanceof ConfigurationException) {
                throw (ConfigurationException)ex;
            }
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC174E, ex);
        }
        finally {
            members_map.unlock((Object)info.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void storeNodeInfo(NodeInfo info) {
        IMap members_map = Main.HAZELCAST.getMap("org.pepstock.jem.nodes");
        try {
            members_map.lock((Object)info.getKey());
            if (!members_map.containsKey((Object)info.getKey())) {
                members_map.put((Object)info.getKey(), (Object)info);
            } else {
                members_map.replace((Object)info.getKey(), (Object)info);
            }
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC174E, ex);
        }
        finally {
            members_map.unlock((Object)info.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<NodeInfo> getNodesInfoByStatus(List<Status> statusList, boolean notIn, boolean includeSupernode) {
        ArrayList<NodeInfo> nodesInfo = new ArrayList<NodeInfo>();
        IMap members_map = Main.HAZELCAST.getMap("org.pepstock.jem.nodes");
        try {
            members_map.lockMap(10L, TimeUnit.SECONDS);
            Iterator it = members_map.values().iterator();
            while (it.hasNext()) {
                NodeInfo currNodeInfo = (NodeInfo)it.next();
                if (includeSupernode && currNodeInfo.isSuperNode()) {
                    nodesInfo.add((NodeInfo)it.next());
                }
                if (currNodeInfo.isSuperNode()) continue;
                nodesInfo.add((NodeInfo)it.next());
            }
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC174E, ex);
        }
        finally {
            members_map.unlockMap();
        }
        if (statusList == null || statusList.isEmpty()) {
            return nodesInfo;
        }
        ArrayList<NodeInfo> nodesInfoToReturn = new ArrayList<NodeInfo>();
        for (int j = 0; j < nodesInfo.size(); ++j) {
            NodeInfo currNodeInfo = (NodeInfo)nodesInfo.get(j);
            if (statusList.contains(currNodeInfo.getStatus()) && !notIn) {
                nodesInfoToReturn.add(currNodeInfo);
            }
            if (statusList.contains(currNodeInfo.getStatus()) || !notIn) continue;
            nodesInfoToReturn.add(currNodeInfo);
        }
        return nodesInfoToReturn;
    }

    public static void drain() {
        DistributedTask task = new DistributedTask((Callable)new Drain(), Main.HAZELCAST.getCluster().getLocalMember());
        ExecutorService executorService = Main.HAZELCAST.getExecutorService();
        task.setExecutionCallback((ExecutionCallback)new GenericCallBack());
        executorService.execute((Runnable)task);
    }

    public static void start() {
        DistributedTask task = new DistributedTask((Callable)new Start(), Main.HAZELCAST.getCluster().getLocalMember());
        ExecutorService executorService = Main.HAZELCAST.getExecutorService();
        task.setExecutionCallback((ExecutionCallback)new GenericCallBack());
        executorService.execute((Runnable)task);
    }
}

