/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node;

import com.hazelcast.config.FileSystemXmlConfig;
import com.hazelcast.core.HazelcastInstance;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.HashMap;
import org.pepstock.jem.factories.JemFactory;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.CancelableTask;
import org.pepstock.jem.node.ExecutionEnvironment;
import org.pepstock.jem.node.InputQueueManager;
import org.pepstock.jem.node.JclCheckingQueueManager;
import org.pepstock.jem.node.NodeInfo;
import org.pepstock.jem.node.NodeInfoUtility;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.OutputSystem;
import org.pepstock.jem.node.ShutDownHandler;
import org.pepstock.jem.node.StartUpSystem;
import org.pepstock.jem.node.StatisticsManager;
import org.pepstock.jem.node.Submitter;
import org.pepstock.jem.node.affinity.AffinityLoader;
import org.pepstock.jem.node.configuration.ConfigurationException;
import org.pepstock.jem.node.events.JobLifecycleListenersSystem;
import org.pepstock.jem.node.resources.custom.ResourceDefinitionsManager;
import org.pepstock.jem.node.tasks.platform.CurrentPlatform;
import org.pepstock.jem.util.Parser;
import org.pepstock.jem.util.rmi.RegistryContainer;

public class Main {
    public static boolean IS_COORDINATOR = false;
    public static final ExecutionEnvironment EXECUTION_ENVIRONMENT = new ExecutionEnvironment();
    public static AffinityLoader AFFINITY_LOADER = null;
    public static InputQueueManager INPUT_QUEUE_MANAGER = null;
    public static NodeInfo NODE = null;
    public static CancelableTask CURRENT_TASK = null;
    public static OutputSystem OUTPUT_SYSTEM = null;
    public static final HashMap<String, JemFactory> FACTORIES_LIST = new HashMap();
    public static final JobLifecycleListenersSystem JOB_LIFECYCLE_LISTENERS_SYSTEM = new JobLifecycleListenersSystem();
    public static final ResourceDefinitionsManager CUSTOM_RESOURCE_DEFINITION_MANAGER = new ResourceDefinitionsManager();
    public static HazelcastInstance HAZELCAST = null;
    public static FileSystemXmlConfig HAZELCAST_CONFIG = null;
    public static StatisticsManager STATISTICS_MANAGER = null;
    public static boolean IS_ACCESS_MAINT = false;
    public static boolean IS_SHUTTING_DOWN = false;
    public static long NUMBER_OF_JCL_CHECK = 0L;
    public static long NUMBER_OF_JOB_SUBMITTED = 0L;
    private JclCheckingQueueManager jclChecker = new JclCheckingQueueManager();
    private Submitter submitter = new Submitter();

    public Main() {
        try {
            CurrentPlatform.getInstance();
            IS_ACCESS_MAINT = Parser.parseBoolean(System.getProperty("jem.access.maint"), false);
            if (IS_ACCESS_MAINT) {
                LogAppl.getInstance().emit(NodeMessage.JEMC189I);
            }
            StartUpSystem.run();
            int objectPort = NODE.getPort() + 200;
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC013I, String.valueOf(objectPort));
            RegistryContainer.createInstance(objectPort);
            LogAppl.getInstance().emit(NodeMessage.JEMC014I);
            NODE.setRmiPort(objectPort);
            STATISTICS_MANAGER.init();
            NodeInfoUtility.checkAndStoreNodeInfo(NODE);
            INPUT_QUEUE_MANAGER = new InputQueueManager();
            Runtime.getRuntime().addShutdownHook(new ShutDownHandler(this.jclChecker, this.submitter));
            this.waitState();
        }
        catch (ConfigurationException e1) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC006E, e1);
            System.exit(12);
        }
        catch (RemoteException e1) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC007E, e1);
            System.exit(12);
        }
        catch (Exception e1) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC194E, e1);
            System.exit(12);
        }
    }

    public synchronized void waitState() {
        this.jclChecker.start();
        this.submitter.start();
        if (Boolean.parseBoolean(System.getenv("RUNNING_IN_ECLIPSE"))) {
            System.err.println("You're using Eclipse; click in this console and\tpress ENTER to call System.exit() and run the shutdown routine.");
            try {
                System.in.read();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                while (true) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        System.exit(0);
    }

    public static void main(String[] args) {
        System.setProperty("java.net.preferIPv4Stack", Boolean.TRUE.toString());
        new Main();
    }
}

