/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node;

import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.SigarProxyCache;
import org.pepstock.jem.Jcl;
import org.pepstock.jem.Job;
import org.pepstock.jem.Step;
import org.pepstock.jem.node.Main;
import org.pepstock.jem.util.DateFormatter;

public class JobLogManager {
    private static long PREVIOUS_CPU = 0L;
    private static final MessageFormat HEADER_JOB = new MessageFormat("J E M  job log -- Node {0}");
    private static final MessageFormat ROW_DATE = new MessageFormat("---- {0} ----");
    private static final MessageFormat ROW_USER = new MessageFormat("USERID {0} IS ASSIGNED TO THIS JOB");
    private static final MessageFormat ROW_JOB_INFO = new MessageFormat("{0} ENVIRONMENT {1} - DOMAIN {2} - AFFINITY {3}");
    private static final MessageFormat ROW_JOB_PID = new MessageFormat("{0} PROCESS-ID {1}");
    private static final MessageFormat ROW_JOB_TIME_STARTED = new MessageFormat("{0} STARTED - TIME={1}");
    private static final String HEADER_JOB_NAME = "JOBNAME";
    private static final String HEADER_STEPS = "STEPNAME         RC   CPU(ms)    MEMORY(kb)       ";
    private static final MessageFormat ROW_JOB_TIME_ENDED = new MessageFormat("{0} ENDED - TIME={1} - RC={2}");

    public static void printHeader(Job job) {
        Main.OUTPUT_SYSTEM.writeJobLog(job, JobLogManager.getFormattedMessage(HEADER_JOB, Main.NODE.getLabel()));
        Main.OUTPUT_SYSTEM.writeJobLog(job, JobLogManager.getFormattedMessage(ROW_DATE, DateFormatter.getCurrentDate("EEEE, dd MMMM yyyy").toUpperCase()));
        Jcl jcl = job.getJcl();
        Main.OUTPUT_SYSTEM.writeJobLog(job, JobLogManager.getFormattedMessage(ROW_USER, job.isUserSurrogated() ? job.getJcl().getUser() : job.getUser()));
        Main.OUTPUT_SYSTEM.writeJobLog(job, JobLogManager.getFormattedMessage(ROW_JOB_INFO, job.getName(), jcl.getEnvironment(), jcl.getDomain(), jcl.getAffinity()));
        Main.OUTPUT_SYSTEM.writeJobLog(job, JobLogManager.getFormattedMessage(ROW_JOB_TIME_STARTED, job.getName(), DateFormatter.getDate(job.getStartedTime(), "HH:mm:ss ")));
    }

    public static void printJobStarted(Job job) {
        PREVIOUS_CPU = 0L;
        Main.OUTPUT_SYSTEM.writeJobLog(job, JobLogManager.getFormattedMessage(ROW_JOB_PID, job.getName(), Main.CURRENT_TASK.getProcessId()));
        Main.OUTPUT_SYSTEM.writeJobLog(job, " ");
        int length = Math.max(job.getName().length(), 16);
        Main.OUTPUT_SYSTEM.writeJobLog(job, StringUtils.rightPad((String)HEADER_JOB_NAME, (int)length) + " " + HEADER_STEPS);
        JobLogManager.printStepResult(job, null);
    }

    public static void printStepResult(Job job, Step step) {
        Sigar sigar = new Sigar();
        SigarProxy proxy = SigarProxyCache.newInstance((Sigar)sigar, (int)0);
        int length = Math.max(job.getName().length(), 16);
        StringBuffer sb = new StringBuffer(StringUtils.rightPad((String)job.getName(), (int)length));
        if (step == null) {
            sb.append(' ').append(StringUtils.rightPad((String)"[init]", (int)16));
            sb.append(' ').append(StringUtils.rightPad((String)"-", (int)4));
        } else {
            sb.append(' ').append(StringUtils.rightPad((String)step.getName(), (int)16));
            sb.append(' ').append(StringUtils.rightPad((String)String.valueOf(step.getReturnCode()), (int)4));
        }
        String pid = job.getProcessId();
        String id = pid.substring(0, pid.indexOf("@"));
        try {
            long cpu = proxy.getProcCpu(id).getTotal() - PREVIOUS_CPU;
            sb.append(' ').append(StringUtils.rightPad((String)String.valueOf(cpu), (int)10));
            PREVIOUS_CPU = cpu;
        }
        catch (SigarException e) {
            sb.append(' ').append(StringUtils.rightPad((String)"N/A", (int)10));
        }
        try {
            sb.append(' ').append(StringUtils.rightPad((String)String.valueOf(proxy.getProcMem(id).getResident() / 1024L), (int)10));
        }
        catch (SigarException e) {
            sb.append(' ').append(StringUtils.rightPad((String)"N/A", (int)10));
        }
        Main.OUTPUT_SYSTEM.writeJobLog(job, sb.toString());
        sigar.close();
        SigarProxyCache.clear((Object)proxy);
    }

    public static void printFooter(Job job, int returnCode, String exception) {
        PREVIOUS_CPU = 0L;
        Main.OUTPUT_SYSTEM.writeJobLog(job, " ");
        Main.OUTPUT_SYSTEM.writeJobLog(job, JobLogManager.getFormattedMessage(ROW_JOB_TIME_ENDED, job.getName(), DateFormatter.getDate(job.getEndedTime(), "HH:mm:ss "), returnCode));
        if (exception != null) {
            Main.OUTPUT_SYSTEM.writeJobLog(job, exception);
        }
    }

    private static synchronized String getFormattedMessage(MessageFormat format, Object ... objects) {
        return format.format(objects);
    }
}

