/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node;

import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ITopic;
import com.hazelcast.query.Predicate;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.AuthorizationException;
import org.pepstock.jem.DefaultJcl;
import org.pepstock.jem.Jcl;
import org.pepstock.jem.Job;
import org.pepstock.jem.PreJob;
import org.pepstock.jem.Result;
import org.pepstock.jem.factories.JclFactoryException;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.Factory;
import org.pepstock.jem.node.Main;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.ShutDownInterface;
import org.pepstock.jem.node.events.JobLifecycleEvent;
import org.pepstock.jem.node.security.RegExpPermission;
import org.pepstock.jem.node.security.Role;
import org.pepstock.jem.node.security.RolesQueuePredicate;
import org.pepstock.jem.node.security.StringPermission;
import org.pepstock.jem.node.security.User;

public class JclCheckingQueueManager
extends Thread
implements ShutDownInterface {
    private boolean isDown = false;

    @Override
    public void run() {
        IQueue jclCheckingQueue = Main.HAZELCAST.getQueue("org.pepstock.jem.jcl.checking");
        try {
            while (!Main.IS_SHUTTING_DOWN) {
                if (Main.NODE.isOperational() && !Main.IS_ACCESS_MAINT) {
                    PreJob prejob = null;
                    try {
                        prejob = (PreJob)jclCheckingQueue.poll(10L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        LogAppl.getInstance().emit(NodeMessage.JEMC163E);
                    }
                    if (prejob != null) {
                        this.checkAndLoadJcl(prejob);
                        continue;
                    }
                    Thread.sleep(2000L);
                    continue;
                }
                Thread.sleep(15000L);
            }
        }
        catch (InterruptedException e) {
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC068W, StringUtils.substringAfterLast((String)JclCheckingQueueManager.class.getName(), (String)"."));
        }
        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC069I, StringUtils.substringAfterLast((String)JclCheckingQueueManager.class.getName(), (String)"."));
        this.isDown = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAndLoadJcl(PreJob prejob) {
        ++Main.NUMBER_OF_JCL_CHECK;
        Job job = prejob.getJob();
        try {
            User user = new User(job.getUser());
            user.setOrgUnitId(job.getOrgUnit());
            RolesQueuePredicate predicate = new RolesQueuePredicate();
            predicate.setUser(user);
            IMap roles = Main.HAZELCAST.getMap("org.pepstock.jem.roles");
            ArrayList myroles = null;
            if (roles.lockMap(10L, TimeUnit.SECONDS)) {
                try {
                    myroles = new ArrayList(roles.values((Predicate)predicate));
                }
                finally {
                    roles.unlockMap();
                }
            } else {
                throw new Exception(NodeMessage.JEMC119E.toMessage().getFormattedMessage("org.pepstock.jem.roles"));
            }
            StringPermission jobSubmitPermission = new StringPermission("jobs:submit");
            boolean allowedJobSubmit = false;
            for (Role role : myroles) {
                if (role.getName().equalsIgnoreCase("administrator")) {
                    allowedJobSubmit = true;
                } else {
                    for (String permission : role.getPermissions()) {
                        StringPermission perm = new StringPermission(permission);
                        if (!perm.implies(new StringPermission("jobs:submit"))) continue;
                        allowedJobSubmit = true;
                        break;
                    }
                }
                if (!allowedJobSubmit) continue;
                break;
            }
            if (!allowedJobSubmit) {
                throw new AuthorizationException(NodeMessage.JEMC144E.toMessage().getFormattedMessage(job.getUser(), jobSubmitPermission));
            }
            Factory.loadJob(prejob);
            if (job.isUserSurrogated()) {
                StringPermission surrogatePermission = new StringPermission("surrogate:" + job.getJcl().getUser());
                boolean allowed = false;
                for (Role role : myroles) {
                    if (role.getName().equalsIgnoreCase("administrator")) {
                        allowed = true;
                    } else {
                        for (String permission : role.getPermissions()) {
                            if (permission.equalsIgnoreCase("surrogate:*")) {
                                allowed = true;
                            } else if (permission.startsWith("surrogate")) {
                                RegExpPermission perm = new RegExpPermission(permission);
                                allowed = perm.implies(surrogatePermission);
                            }
                            if (!allowed) continue;
                            break;
                        }
                    }
                    if (!allowed) continue;
                    break;
                }
                if (!allowed) {
                    throw new AuthorizationException(NodeMessage.JEMC144E.toMessage().getFormattedMessage(job.getUser(), surrogatePermission));
                }
            }
            IMap inputQueue = Main.HAZELCAST.getMap("org.pepstock.jem.input");
            try {
                inputQueue.lock((Object)job.getId());
                inputQueue.put((Object)job.getId(), (Object)job);
                Main.JOB_LIFECYCLE_LISTENERS_SYSTEM.addJobLifecycleEvent(new JobLifecycleEvent("org.pepstock.jem.input", job));
            }
            catch (Exception ex) {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC170E, ex, job.getName());
            }
            finally {
                inputQueue.unlock((Object)job.getId());
            }
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            Result result = new Result();
            result.setReturnCode(16);
            result.setExceptionMessage(sw.getBuffer().toString());
            job.setResult(result);
            job.setEndedTime(new Date());
            Jcl jcl = null;
            if (e instanceof JclFactoryException) {
                JclFactoryException jfe = (JclFactoryException)e;
                jcl = jfe.getJcl();
            }
            if (jcl == null) {
                jcl = new DefaultJcl();
                jcl.setContent(prejob.getJclContent());
                jcl.setType(prejob.getJclType());
            }
            job.setName(jcl.getJobName() == null ? "UNKNOWN" : jcl.getJobName());
            job.setJcl(jcl);
            try {
                Main.OUTPUT_SYSTEM.writeJcl(job);
                Main.OUTPUT_SYSTEM.writeMessageLog(job, sw.toString());
            }
            catch (FileNotFoundException e1) {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC155W, e1, job.getName());
            }
            catch (IOException e1) {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC155W, e1, job.getName());
            }
            IMap outputQueue = Main.HAZELCAST.getMap("org.pepstock.jem.output");
            try {
                outputQueue.lock((Object)job.getId());
                outputQueue.put((Object)job.getId(), (Object)job);
            }
            catch (Exception ex) {
                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC171E, ex, job.getName());
            }
            finally {
                outputQueue.unlock((Object)job.getId());
            }
            Main.JOB_LIFECYCLE_LISTENERS_SYSTEM.addJobLifecycleEvent(new JobLifecycleEvent("org.pepstock.jem.output", job));
            ITopic topic = Main.HAZELCAST.getTopic("org.pepstock.jem.job.ended");
            topic.publish((Object)job);
        }
    }

    @Override
    public void shutdown() throws Exception {
        while (!this.isDown) {
            Thread.sleep(1000L);
        }
    }
}

