/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.node;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.query.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.concurrent.LinkedBlockingQueue;
import org.pepstock.jem.Jcl;
import org.pepstock.jem.Job;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.InputQueuePredicate;
import org.pepstock.jem.node.JobComparator;
import org.pepstock.jem.node.Main;
import org.pepstock.jem.node.NodeInfoUtility;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.ShutDownInterface;
import org.pepstock.jem.node.ShutDownJob;
import org.pepstock.jem.node.Status;

public class InputQueueManager
implements EntryListener<String, Job>,
ShutDownInterface {
    private LinkedBlockingQueue<Job> queue = null;
    private JobComparator comparator = new JobComparator();
    private InputQueuePredicate predicate = new InputQueuePredicate();

    public InputQueueManager() {
        this.queue = new LinkedBlockingQueue();
        IMap inputQueue = Main.HAZELCAST.getMap("org.pepstock.jem.input");
        inputQueue.addEntryListener((EntryListener)this, true);
        this.predicate.setExecutionEnviroment(Main.EXECUTION_ENVIRONMENT);
    }

    public Job takeJob() throws InterruptedException {
        return this.queue.take();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkJobToSubmit() {
        if (Main.IS_ACCESS_MAINT) {
            if (!Main.NODE.getStatus().equals(Status.DRAINED)) {
                LogAppl.getInstance().emit(NodeMessage.JEMC189I);
                NodeInfoUtility.drain();
            }
            return;
        }
        Main.NODE.getLock().lock();
        try {
            if (Main.NODE.getStatus().equals(Status.DRAINED) || Main.NODE.getStatus().equals(Status.DRAINING) || Main.NODE.getStatus().equals(Status.ACTIVE)) {
                return;
            }
            Main.NODE.setStatus(Status.ACTIVE);
            NodeInfoUtility.storeNodeInfo(Main.NODE);
            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC030I, Main.NODE.getStatus());
        }
        finally {
            Main.NODE.getLock().unlock();
        }
        IMap inputQueue = Main.HAZELCAST.getMap("org.pepstock.jem.input");
        Collection jobs = inputQueue.values((Predicate)this.predicate);
        if (!jobs.isEmpty()) {
            ArrayList queuedJobs = new ArrayList(jobs);
            Collections.sort(queuedJobs, this.comparator);
            for (Job job : queuedJobs) {
                boolean mustReturn;
                block19: {
                    mustReturn = false;
                    try {
                        inputQueue.lock((Object)job.getId());
                        if (!inputQueue.containsKey((Object)job.getId())) break block19;
                        IMap runningQueue = Main.HAZELCAST.getMap("org.pepstock.jem.running");
                        job.setMemberId(Main.NODE.getKey());
                        job.setMemberLabel(Main.NODE.getLabel());
                        job.setStartedTime(new Date());
                        job.setRunningStatus(1);
                        try {
                            runningQueue.lock((Object)job.getId());
                            Job storedJob = (Job)inputQueue.remove((Object)job.getId());
                            if (storedJob != null) {
                                this.queue.put(job);
                                runningQueue.put((Object)job.getId(), (Object)job);
                                mustReturn = true;
                                LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC018I, job.toString());
                            }
                        }
                        catch (Exception ex) {
                            LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC017E, ex);
                        }
                        finally {
                            runningQueue.unlock((Object)job.getId());
                        }
                    }
                    finally {
                        inputQueue.unlock((Object)job.getId());
                    }
                }
                if (!mustReturn) continue;
                return;
            }
        }
        Main.NODE.setStatus(Status.INACTIVE);
        NodeInfoUtility.storeNodeInfo(Main.NODE);
        LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC030I, Main.NODE.getStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isRouted(Job job) {
        boolean isRouted = false;
        Jcl jcl = job.getJcl();
        if (!jcl.getEnvironment().equalsIgnoreCase(Main.EXECUTION_ENVIRONMENT.getEnvironment())) {
            ILock lock = Main.HAZELCAST.getLock((Object)"org.pepstock.jem.input");
            lock.lock();
            try {
                IMap inputQueue = Main.HAZELCAST.getMap("org.pepstock.jem.input");
                if (inputQueue.containsKey((Object)job.getId())) {
                    IMap routingQueue = Main.HAZELCAST.getMap("org.pepstock.jem.routing");
                    inputQueue.remove((Object)job.getId());
                    routingQueue.put((Object)job.getId(), (Object)job);
                    isRouted = true;
                    LogAppl.getInstance().emit((MessageInterface)NodeMessage.JEMC019I, job.toString(), jcl.getEnvironment());
                }
            }
            finally {
                lock.unlock();
            }
        }
        return isRouted;
    }

    public void entryAdded(EntryEvent<String, Job> event) {
        if (Main.IS_SHUTTING_DOWN || Main.IS_ACCESS_MAINT) {
            return;
        }
        Job job = (Job)event.getValue();
        if (!this.isRouted(job) && Main.NODE.getStatus().equals(Status.INACTIVE)) {
            this.checkJobToSubmit();
        }
    }

    public void entryEvicted(EntryEvent<String, Job> event) {
    }

    public void entryRemoved(EntryEvent<String, Job> event) {
    }

    public void entryUpdated(EntryEvent<String, Job> event) {
        if (Main.IS_SHUTTING_DOWN || Main.IS_ACCESS_MAINT) {
            return;
        }
        Job job = (Job)event.getValue();
        if (!this.isRouted(job) && Main.NODE.getStatus().equals(Status.INACTIVE)) {
            this.checkJobToSubmit();
        }
    }

    @Override
    public void shutdown() throws Exception {
        this.queue.put(ShutDownJob.JOB);
    }
}

