/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.log;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.xml.DOMConfigurator;
import org.pepstock.jem.log.MessageInterface;

public class LogAppl {
    public static final String LOG4J_CONFIGURATION_PROPERTY = "log4j.config";
    private static final String NAME = "jem";
    private static LogAppl LOGAPPL = null;
    private Logger logger = null;

    public static LogAppl getInstance() {
        return LogAppl.getInstance(null);
    }

    public static LogAppl getInstance(PrintStream consoleStream) {
        if (LOGAPPL == null) {
            LOGAPPL = new LogAppl(consoleStream);
        }
        return LOGAPPL;
    }

    private LogAppl(PrintStream consoleStream) {
        String fileName = System.getProperty(LOG4J_CONFIGURATION_PROPERTY);
        if (fileName != null) {
            DOMConfigurator.configure((String)fileName);
        } else if (consoleStream != null) {
            ConsoleAppender consoleAppeder = new ConsoleAppender();
            consoleAppeder.setName("consoleAppender");
            consoleAppeder.setWriter((Writer)new PrintWriter(consoleStream));
            consoleAppeder.setThreshold((Priority)Level.INFO);
            PatternLayout layout = new PatternLayout();
            layout.setConversionPattern("%m%n");
            consoleAppeder.setLayout((Layout)layout);
            BasicConfigurator.resetConfiguration();
            BasicConfigurator.configure((Appender)consoleAppeder);
        } else {
            ConsoleAppender consoleAppeder = new ConsoleAppender();
            consoleAppeder.setName("consoleAppender");
            consoleAppeder.setWriter((Writer)new PrintWriter(System.out));
            consoleAppeder.setThreshold((Priority)Level.INFO);
            PatternLayout layout = new PatternLayout();
            layout.setConversionPattern("%d{yyyy MM dd HH:mm:ss} %-6p [%t] %m%n");
            consoleAppeder.setLayout((Layout)layout);
            BasicConfigurator.resetConfiguration();
            BasicConfigurator.configure((Appender)consoleAppeder);
        }
        this.logger = Logger.getLogger((String)NAME);
    }

    public void emit(MessageInterface message) {
        this.emit(message, (Object[])null);
    }

    public void emit(MessageInterface message, Object ... objects) {
        this.emit(message, null, objects);
    }

    public void emit(MessageInterface message, Throwable exception) {
        this.emit(message, exception, (Object[])null);
    }

    public void emit(MessageInterface message, Throwable exception, Object ... objects) {
        String outputMessage = objects == null ? message.toMessage().getMessage() : message.toMessage().getFormattedMessage(objects);
        switch (message.toMessage().getLevel()) {
            case 0: {
                this.logger.info((Object)outputMessage);
                break;
            }
            case 1: {
                if (exception == null) {
                    this.logger.warn((Object)outputMessage);
                    break;
                }
                this.logger.warn((Object)outputMessage, exception);
                break;
            }
            case 2: {
                if (exception == null) {
                    this.logger.error((Object)outputMessage);
                    break;
                }
                this.logger.error((Object)outputMessage, exception);
                break;
            }
            default: {
                this.logger.info((Object)outputMessage);
            }
        }
    }

    public void debug(Object object) {
        this.logger.debug(object);
    }
}

