/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.log;

import java.io.StringWriter;
import java.io.Writer;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.LoggingEvent;
import org.pepstock.jem.log.LogBuffer;

public class InMemoryAppender
extends WriterAppender {
    private static StringWriter buffer = new StringWriter();

    public InMemoryAppender() {
        super((Layout)new PatternLayout(), (Writer)buffer);
        this.setImmediateFlush(true);
        PatternLayout layout = new PatternLayout();
        layout.setConversionPattern("%d{yyyy MM dd HH:mm:ss} %-6p [%t] %m%n");
        this.setLayout((Layout)layout);
    }

    public void append(LoggingEvent loggingEvent) {
        StringBuffer sb = buffer.getBuffer();
        sb.delete(0, sb.length());
        super.append(loggingEvent);
        LogBuffer.getInstance().addLog(sb);
    }

    public long getMaxRows() {
        return LogBuffer.getInstance().getMaxRows();
    }

    public void setMaxRows(long maxRows) {
        LogBuffer.getInstance().setMaxRows(maxRows);
    }
}

