/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.jppf;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.UUID;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.lang3.StringUtils;
import org.apache.tools.ant.BuildException;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.TypedProperties;
import org.pepstock.jem.ant.AntMessage;
import org.pepstock.jem.ant.tasks.DataDescription;
import org.pepstock.jem.ant.tasks.DataSet;
import org.pepstock.jem.ant.tasks.StepJava;
import org.pepstock.jem.ant.tasks.managers.DataDescriptionManager;
import org.pepstock.jem.jppf.ExecuteManager;
import org.pepstock.jem.jppf.JPPFMessage;
import org.pepstock.jem.jppf.Keys;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.node.tasks.jndi.ContextUtils;

public class StepJPPF
extends StepJava {
    private String runnable = null;
    private String address = null;
    private int parallelTaskNumber = Keys.DEFAULT_PARALLEL_TASK_NUMBER;
    private String datasource = null;
    private String delimiter = null;
    private String delimiterString = null;
    private String chunkableDataDescription = null;
    private String mergedDataDescription = null;

    public int getParallelTaskNumber() {
        return this.parallelTaskNumber;
    }

    public void setParallelTaskNumber(int parallelTaskNumber) {
        this.parallelTaskNumber = parallelTaskNumber;
    }

    public String getRunnable() {
        return this.runnable;
    }

    public void setRunnable(String runnable) {
        this.runnable = runnable;
    }

    public String getDatasource() {
        return this.datasource;
    }

    public void setDatasource(String datasource) {
        this.datasource = datasource;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getDelimiterString() {
        return this.delimiterString;
    }

    public void setDelimiterString(String delimiterString) {
        this.delimiterString = delimiterString;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getChunkableDataDescription() {
        return this.chunkableDataDescription;
    }

    public void setChunkableDataDescription(String chunkableDataDescription) {
        this.chunkableDataDescription = chunkableDataDescription;
    }

    public String getMergedDataDescription() {
        return this.mergedDataDescription;
    }

    public void setMergedDataDescription(String mergedDataDescription) {
        this.mergedDataDescription = mergedDataDescription;
    }

    @Override
    public void execute() throws BuildException {
        if (this.runnable == null) {
            throw new BuildException(JPPFMessage.JEMJ001E.toMessage().getFormattedMessage(new Object[0]));
        }
        LogAppl.getInstance();
        super.setClassname(StepJPPF.class.getName());
        UUID uuid = UUID.randomUUID();
        DataDescription dd = new DataDescription();
        dd.setName(uuid.toString());
        DataSet ds = new DataSet();
        XStream xstream = new XStream();
        TypedProperties props = new TypedProperties();
        props.setProperty("jppf.discovery.enabled", Boolean.FALSE.toString());
        if (this.address != null) {
            this.address = StringUtils.remove((String)this.address, (String)" ");
            String[] addresses = StringUtils.split((String)this.address, (String)",");
            if (addresses != null && addresses.length > 0) {
                StringBuffer drivers = new StringBuffer();
                for (int i = 0; i < addresses.length; ++i) {
                    if (!addresses[i].contains(":")) {
                        throw new BuildException(JPPFMessage.JEMJ008E.toMessage().getFormattedMessage(addresses[i]));
                    }
                    String host = StringUtils.substringBefore((String)addresses[i], (String)":");
                    String port = StringUtils.substringAfter((String)addresses[i], (String)":");
                    String driver = "jem" + i;
                    props.setProperty(driver + ".jppf.server.port", port);
                    props.setProperty(driver + ".jppf.server.host", host);
                    drivers.append(driver).append(" ");
                }
                props.setProperty("jppf.drivers", drivers.toString());
            }
        }
        if (this.datasource != null) {
            props.setProperty("jem.datasource", this.datasource);
        }
        props.setProperty("jem.runnable", this.runnable);
        props.setProperty("jem.task.number", String.valueOf(Math.max(1, this.parallelTaskNumber)));
        String jobName = this.getProject().getProperty("jem.job.name") != null ? this.getProject().getProperty("jem.job.name") : this.getProject().getName();
        props.setProperty("jem.job.name", jobName);
        props.setProperty("jem.task.name", super.getTargetName());
        if (this.delimiter != null && this.delimiterString != null) {
            throw new BuildException(JPPFMessage.JEMJ027E.toMessage().getFormattedMessage(new Object[0]));
        }
        if ((this.delimiter != null || this.delimiterString != null) && this.chunkableDataDescription == null) {
            throw new BuildException(JPPFMessage.JEMJ013E.toMessage().getFormattedMessage(new Object[0]));
        }
        if (this.chunkableDataDescription != null) {
            this.containsDataDescription(this.chunkableDataDescription, false);
            props.setProperty("jem.chunkable.data.description", this.chunkableDataDescription);
            if (this.delimiter != null) {
                props.setProperty("jem.delimiter", this.delimiter);
            } else if (this.delimiterString != null) {
                props.setProperty("jem.delimiter.string", this.delimiterString);
            }
        }
        if (this.mergedDataDescription != null) {
            this.containsDataDescription(this.mergedDataDescription, true);
            props.setProperty("jem.merged.data.description", this.mergedDataDescription);
        }
        ds.addText(xstream.toXML((Object)props));
        dd.addDataSet(ds);
        super.addDataDescription(dd);
        try {
            DataDescriptionManager.createDataDescriptionImpl(dd, this);
        }
        catch (IOException e) {
            throw new BuildException(AntMessage.JEMA003E.toMessage().getFormattedMessage(new Object[0]), (Throwable)e);
        }
        super.createArg().setValue(uuid.toString());
        super.execute();
    }

    private void containsDataDescription(String name, boolean write) throws BuildException {
        boolean found = false;
        for (DataDescription ddescription : this.getDataDescriptions()) {
            if (!ddescription.getName().equalsIgnoreCase(name)) continue;
            if (write) {
                if (ddescription.getDisposition().equalsIgnoreCase("SHR")) {
                    throw new BuildException(JPPFMessage.JEMJ014E.toMessage().getFormattedMessage(name));
                }
            } else {
                if (!ddescription.getDisposition().equalsIgnoreCase("SHR")) {
                    throw new BuildException(JPPFMessage.JEMJ015E.toMessage().getFormattedMessage(name));
                }
                if (ddescription.isMultiDataset()) {
                    throw new BuildException(JPPFMessage.JEMJ016E.toMessage().getFormattedMessage(name));
                }
                DataSet ddataset = ddescription.getDatasets().iterator().next();
                if (ddataset.isDatasource()) {
                    throw new BuildException(JPPFMessage.JEMJ017E.toMessage().getFormattedMessage(name));
                }
                if (ddataset.isInline()) {
                    throw new BuildException(JPPFMessage.JEMJ018E.toMessage().getFormattedMessage(name));
                }
            }
            found = true;
            break;
        }
        if (!found) {
            throw new BuildException(JPPFMessage.JEMJ019E.toMessage().getFormattedMessage(name));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) throws Exception {
        LogAppl.getInstance();
        InitialContext ic = ContextUtils.getContext();
        XStream xstream = new XStream();
        TypedProperties propsFromDataDescritpion = new TypedProperties();
        try {
            Object ddconfig = ic.lookup("JPPF-CONFIG");
            InputStream configInputStream = (InputStream)ddconfig;
            propsFromDataDescritpion.load(configInputStream);
        }
        catch (NamingException e) {
            // empty catch block
        }
        String uuid = args[0];
        Object ddin = ic.lookup(uuid);
        InputStream configInputStream = (InputStream)ddin;
        TypedProperties propsFromTag = (TypedProperties)xstream.fromXML(configInputStream);
        if (propsFromTag.getProperty("jem.datasource") != null) {
            String datasource = propsFromTag.getProperty("jem.datasource");
            Object configResource = ic.lookup(datasource);
            if (!(configResource instanceof TypedProperties)) throw new Exception(JPPFMessage.JEMJ010E.toMessage().getFormattedMessage("jem.datasource", configResource.getClass().getName(), TypedProperties.class.getName()));
            TypedProperties props = (TypedProperties)configResource;
            JPPFConfiguration.getProperties().putAll((Map)propsFromDataDescritpion);
            JPPFConfiguration.getProperties().putAll((Map)propsFromTag);
            JPPFConfiguration.getProperties().putAll((Map)props);
        } else {
            JPPFConfiguration.getProperties().putAll((Map)propsFromDataDescritpion);
            JPPFConfiguration.getProperties().putAll((Map)propsFromTag);
        }
        String icXml = xstream.toXML((Object)ic);
        ExecuteManager.submit(icXml);
    }
}

