/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.jppf;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.LinkedList;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.StringRefAddr;
import org.jppf.server.protocol.JPPFTask;
import org.pepstock.jem.jppf.DataStreamNameClassPair;
import org.pepstock.jem.jppf.JPPFMessage;
import org.pepstock.jem.jppf.RemoteDataStreamReference;
import org.pepstock.jem.jppf.RemoteStandardOutputStream;
import org.pepstock.jem.jppf.TaskData;
import org.pepstock.jem.jppf.TaskInfo;
import org.pepstock.jem.jppf.UniqueInitialContext;
import org.pepstock.jem.node.tasks.jndi.DataStreamReference;
import org.pepstock.jem.util.Parser;

public class RunnableTask
extends JPPFTask {
    private static final long serialVersionUID = 1L;
    private Runnable runnable = null;

    public RunnableTask(Runnable runnable) {
        this.runnable = runnable;
    }

    public void run() {
        block8: {
            System.setErr(new PrintStream(new RemoteStandardOutputStream(this)));
            System.setOut(new PrintStream(new RemoteStandardOutputStream(this)));
            this.setId("Task[" + this.getPosition() + "]");
            TaskData tData = new TaskData();
            tData.setIndex(this.getPosition());
            Object count = null;
            try {
                count = this.getDataProvider().getValue((Object)"jem.task.number");
            }
            catch (Exception e) {
                this.setException(e);
                return;
            }
            int tasks = Parser.parseInt(count.toString(), 1);
            tData.setTotal(tasks);
            TaskInfo.setTaskData(tData);
            XStream xstream = new XStream();
            String thisXml = xstream.toXML((Object)this);
            InitialContext ic = null;
            try {
                String chunks = this.getValueFromDataProvider("jem.chunks");
                String dataDescription = this.getValueFromDataProvider("jem.chunkable.data.description");
                String mergedDataDescription = this.getValueFromDataProvider("jem.merged.data.description");
                File temporayFile = null;
                String temporaryFilesXml = this.getValueFromDataProvider("jem.temporary.files");
                if (temporaryFilesXml != null) {
                    LinkedList temporayFiles = (LinkedList)xstream.fromXML(temporaryFilesXml);
                    temporayFile = (File)temporayFiles.get(this.getPosition());
                }
                String context = this.getValueFromDataProvider("jem.context").toString();
                ic = (InitialContext)xstream.fromXML(context);
                NamingEnumeration<NameClassPair> list = ic.list("");
                while (list.hasMore()) {
                    NameClassPair pair = list.next();
                    if (!(pair instanceof DataStreamNameClassPair)) continue;
                    DataStreamNameClassPair dsPair = (DataStreamNameClassPair)pair;
                    DataStreamReference prevReference = (DataStreamReference)dsPair.getObject();
                    StringRefAddr sra = (StringRefAddr)prevReference.get("jem.datadescrition.object");
                    RemoteDataStreamReference reference = new RemoteDataStreamReference();
                    reference.add(sra);
                    reference.add(new StringRefAddr("jem.jppf.task.object", thisXml));
                    if (chunks != null) {
                        reference.add(new StringRefAddr("jem.chunks.object", chunks));
                        reference.add(new StringRefAddr("jem.chunkable.data.description.object", dataDescription));
                    }
                    if (mergedDataDescription != null && temporayFile != null) {
                        reference.add(new StringRefAddr("jem.merged.data.description.object", mergedDataDescription));
                        reference.add(new StringRefAddr("jem.temporary.file.object", temporayFile.getAbsolutePath()));
                    }
                    ic.rebind(dsPair.getName(), (Object)reference);
                }
                UniqueInitialContext.setContext(ic);
                System.out.println(JPPFMessage.JEMJ004I.toMessage().getFormattedMessage("Task[" + this.getPosition() + "]", InetAddress.getLocalHost().getHostAddress()));
                this.runnable.run();
            }
            catch (Exception e) {
                if (this.getException() != null) break block8;
                this.setException(e);
            }
        }
        System.out.flush();
        System.err.flush();
    }

    private String getValueFromDataProvider(String key) throws Exception {
        Object value = this.getDataProvider().getValue((Object)key);
        if (value != null) {
            return value.toString();
        }
        return null;
    }
}

