/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.jppf;

import java.io.IOException;
import java.io.OutputStream;
import org.jppf.server.protocol.JPPFTask;
import org.jppf.utils.JPPFCallable;

public class RemoteStandardOutputStream
extends OutputStream {
    private static final int BUFFER_SIZE = 512;
    private StringBuffer buffer = new StringBuffer();
    private JPPFTask task = null;

    public RemoteStandardOutputStream(JPPFTask task) {
        this.task = task;
    }

    @Override
    public void flush() throws IOException {
        try {
            this.task.compute((JPPFCallable)new WriteOutput(this.buffer));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.buffer = new StringBuffer();
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer.append((char)b);
        if (this.buffer.length() > 512) {
            this.flush();
        }
    }

    public static class WriteOutput
    implements JPPFCallable<Boolean> {
        private static final long serialVersionUID = 1L;
        private StringBuffer buffer = null;

        public WriteOutput(StringBuffer buffer) {
            this.buffer = buffer;
        }

        public Boolean call() {
            System.out.print(this.buffer.toString());
            return true;
        }
    }
}

